/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm;

import io.seata.core.model.BranchType;
import io.seata.core.model.ResourceManager;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.rm.AbstractRMHandler;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.DataSourceManager;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.undo.UndoLogManagerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMHandlerAT
extends AbstractRMHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMHandlerAT.class);
    private static final int LIMIT_ROWS = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(UndoLogDeleteRequest request) {
        DataSourceManager dataSourceManager = (DataSourceManager)this.getResourceManager();
        DataSourceProxy dataSourceProxy = dataSourceManager.get(request.getResourceId());
        if (dataSourceProxy == null) {
            LOGGER.warn("Failed to get dataSourceProxy for delete undolog on {}", (Object)request.getResourceId());
            return;
        }
        Date logCreatedSave = this.getLogCreated(request.getSaveDays());
        Connection conn = null;
        try {
            conn = dataSourceProxy.getPlainConnection();
            int deleteRows = 0;
            do {
                try {
                    deleteRows = UndoLogManagerFactory.getUndoLogManager(dataSourceProxy.getDbType()).deleteUndoLogByLogCreated(logCreatedSave, 3000, conn);
                    if (deleteRows <= 0 || conn.getAutoCommit()) continue;
                    conn.commit();
                }
                catch (SQLException exx) {
                    if (deleteRows > 0 && !conn.getAutoCommit()) {
                        conn.rollback();
                    }
                    throw exx;
                }
            } while (deleteRows == 3000);
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete expired undo_log, error:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException closeEx) {
                    LOGGER.warn("Failed to close JDBC resource while deleting undo_log ", (Throwable)closeEx);
                }
            }
        }
    }

    private Date getLogCreated(int saveDays) {
        if (saveDays <= 0) {
            saveDays = 7;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -saveDays);
        return calendar.getTime();
    }

    protected ResourceManager getResourceManager() {
        return DefaultResourceManager.get().getResourceManager(BranchType.AT);
    }

    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

