/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.xa;

import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.rm.BaseDataSourceResource;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.xa.AbstractConnectionProxyXA;
import io.seata.rm.datasource.xa.Holdable;
import io.seata.rm.datasource.xa.XAXid;
import io.seata.rm.datasource.xa.XAXidBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProxyXA
extends AbstractConnectionProxyXA
implements Holdable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxyXA.class);
    private boolean currentAutoCommitStatus = true;
    private XAXid xaBranchXid;
    private boolean xaActive = false;
    private boolean kept = false;

    public ConnectionProxyXA(Connection originalConnection, XAConnection xaConnection, BaseDataSourceResource resource, String xid) {
        super(originalConnection, xaConnection, resource, xid);
    }

    public void init() {
        try {
            this.xaResource = this.xaConnection.getXAResource();
            this.currentAutoCommitStatus = this.originalConnection.getAutoCommit();
            if (!this.currentAutoCommitStatus) {
                throw new IllegalStateException("Connection[autocommit=false] as default is NOT supported");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void keepIfNecessary() {
        if (this.shouldBeHeld()) {
            this.resource.hold(this.xaBranchXid.toString(), this);
        }
    }

    private void releaseIfNecessary() {
        if (this.isHeld()) {
            this.resource.release(this.xaBranchXid.toString(), this);
        }
    }

    public void xaCommit(String xid, long branchId, String applicationData) throws XAException {
        XAXid xaXid = XAXidBuilder.build(xid, branchId);
        this.xaResource.commit(xaXid, false);
        this.releaseIfNecessary();
    }

    public void xaRollback(String xid, long branchId, String applicationData) throws XAException {
        XAXid xaXid = XAXidBuilder.build(xid, branchId);
        this.xaRollback(xaXid);
    }

    public void xaRollback(XAXid xaXid) throws XAException {
        this.xaResource.rollback(xaXid);
        this.releaseIfNecessary();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.currentAutoCommitStatus == autoCommit) {
            return;
        }
        if (autoCommit) {
            if (this.xaActive) {
                this.commit();
            }
        } else {
            if (this.xaActive) {
                throw new SQLException("should NEVER happen: setAutoCommit from true to false while xa branch is active");
            }
            long branchId = 0L;
            try {
                branchId = DefaultResourceManager.get().branchRegister(BranchType.XA, this.resource.getResourceId(), null, this.xid, null, null);
            }
            catch (TransactionException te) {
                this.cleanXABranchContext();
                throw new SQLException("failed to register xa branch " + this.xid + " since " + te.getCode() + ":" + te.getMessage(), te);
            }
            this.xaBranchXid = XAXidBuilder.build(this.xid, branchId);
            try {
                this.xaResource.start(this.xaBranchXid, 0);
            }
            catch (XAException e) {
                this.cleanXABranchContext();
                throw new SQLException("failed to start xa branch " + this.xid + " since " + e.getMessage(), e);
            }
            this.xaActive = true;
        }
        this.currentAutoCommitStatus = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.currentAutoCommitStatus;
    }

    @Override
    public void commit() throws SQLException {
        if (this.currentAutoCommitStatus) {
            return;
        }
        if (!this.xaActive || this.xaBranchXid == null) {
            throw new SQLException("should NOT commit on an inactive session", "SQLSTATE_XA_NOT_END");
        }
        try {
            this.xaResource.end(this.xaBranchXid, 0x4000000);
            this.xaResource.prepare(this.xaBranchXid);
            this.keepIfNecessary();
        }
        catch (XAException xe) {
            try {
                DefaultResourceManager.get().branchReport(BranchType.XA, this.xid, this.xaBranchXid.getBranchId(), BranchStatus.PhaseOne_Failed, null);
            }
            catch (TransactionException te) {
                LOGGER.warn("Failed to report XA branch commit-failure on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + te.getCode() + ":" + te.getMessage() + " and XAException:" + xe.getMessage());
            }
            throw new SQLException("Failed to end(TMSUCCESS)/prepare xa branch on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + xe.getMessage(), xe);
        }
        finally {
            this.cleanXABranchContext();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.currentAutoCommitStatus) {
            return;
        }
        if (!this.xaActive || this.xaBranchXid == null) {
            throw new SQLException("should NOT rollback on an inactive session");
        }
        try {
            this.xaResource.end(this.xaBranchXid, 0x20000000);
            this.xaRollback(this.xaBranchXid);
            DefaultResourceManager.get().branchReport(BranchType.XA, this.xid, this.xaBranchXid.getBranchId(), BranchStatus.PhaseOne_Failed, null);
            LOGGER.info(this.xaBranchXid + " was rollbacked");
        }
        catch (XAException xe) {
            throw new SQLException("Failed to end(TMFAIL) xa branch on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + xe.getMessage(), xe);
        }
        catch (TransactionException te) {
            LOGGER.warn("Failed to report XA branch rollback on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + te.getCode() + ":" + te.getMessage());
        }
        finally {
            this.cleanXABranchContext();
        }
    }

    private void cleanXABranchContext() {
        this.xaActive = false;
        if (!this.isHeld()) {
            this.xaBranchXid = null;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isHeld()) {
            return;
        }
        this.cleanXABranchContext();
        this.originalConnection.close();
    }

    @Override
    public void setHeld(boolean kept) {
        this.kept = kept;
    }

    @Override
    public boolean isHeld() {
        return this.kept;
    }

    @Override
    public boolean shouldBeHeld() {
        return "mysql".equals(this.resource.getDbType()) || "mariadb".equals(this.resource.getDbType());
    }
}

