/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.motan;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.Scope;
import com.weibo.api.motan.core.extension.Spi;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import io.seata.core.context.RootContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Spi(scope=Scope.SINGLETON)
@Activation(key={"service", "referer"}, sequence=100)
public class MotanTransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotanTransactionFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response filter(Caller<?> caller, Request request) {
        String currentXid = RootContext.getXID();
        String requestXid = this.getRpcXid(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext [" + currentXid + "] xid in Request [" + requestXid + "]");
        }
        boolean bind = false;
        if (currentXid != null) {
            request.getAttachments().put("TX_XID", currentXid);
        } else if (requestXid != null) {
            RootContext.bind((String)requestXid);
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind [" + requestXid + "] to RootContext");
            }
        }
        try {
            Response response = caller.call(request);
            return response;
        }
        finally {
            if (bind) {
                String unbindXid = RootContext.unbind();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind [" + unbindXid + "] from RootContext");
                }
                if (!requestXid.equalsIgnoreCase(unbindXid)) {
                    LOGGER.warn("xid has changed, during RPC from " + requestXid + " to " + unbindXid);
                    if (unbindXid != null) {
                        RootContext.bind((String)unbindXid);
                        LOGGER.warn("bind [" + unbindXid + "] back to RootContext");
                    }
                }
            }
        }
    }

    private String getRpcXid(Request request) {
        String rpcXid = (String)request.getAttachments().get("TX_XID");
        if (rpcXid == null) {
            rpcXid = (String)request.getAttachments().get("TX_XID".toLowerCase());
        }
        return rpcXid;
    }
}

