/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import java.util.concurrent.atomic.LongAdder;

public class SummaryValue {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final double startMilliseconds;

    public long getCount() {
        return this.count.longValue();
    }

    public long getTotal() {
        return this.total.longValue();
    }

    public double getTps(double currentMilliseconds) {
        if (currentMilliseconds <= this.startMilliseconds) {
            return 0.0;
        }
        return this.total.doubleValue() / (currentMilliseconds - this.startMilliseconds) * 1000.0;
    }

    public SummaryValue(double startMilliseconds) {
        this.startMilliseconds = startMilliseconds;
    }

    public void increase() {
        this.increase(1L);
    }

    public void increase(long value) {
        if (value < 0L) {
            return;
        }
        this.count.increment();
        this.total.add(value);
    }
}

