/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.exporter.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.exporter.HTTPServer;
import io.seata.common.loader.LoadLevel;
import io.seata.config.ConfigurationFactory;
import io.seata.metrics.Measurement;
import io.seata.metrics.exporter.Exporter;
import io.seata.metrics.registry.Registry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@LoadLevel(name="prometheus", order=1)
public class PrometheusExporter
extends Collector
implements Collector.Describable,
Exporter {
    private final HTTPServer server;
    private Registry registry;

    public PrometheusExporter() throws IOException {
        int port = ConfigurationFactory.getInstance().getInt("metrics.exporterPrometheusPort", 9898);
        this.server = new HTTPServer(port, true);
        this.register();
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> familySamples = new ArrayList<Collector.MetricFamilySamples>();
        if (this.registry != null) {
            Iterable measurements = this.registry.measure();
            ArrayList samples = new ArrayList();
            measurements.forEach(measurement -> samples.add(this.convertMeasurementToSample((Measurement)measurement)));
            if (!samples.isEmpty()) {
                Collector.Type unknownType = PrometheusExporter.getUnknownType();
                familySamples.add(new Collector.MetricFamilySamples("seata", unknownType, "seata", samples));
            }
        }
        return familySamples;
    }

    private Collector.MetricFamilySamples.Sample convertMeasurementToSample(Measurement measurement) {
        String prometheusName = measurement.getId().getName().replace(".", "_");
        ArrayList labelNames = new ArrayList();
        ArrayList labelValues = new ArrayList();
        for (Map.Entry tag : measurement.getId().getTags()) {
            labelNames.add(tag.getKey());
            labelValues.add(tag.getValue());
        }
        return new Collector.MetricFamilySamples.Sample(prometheusName, labelNames, labelValues, measurement.getValue(), Long.valueOf((long)measurement.getTimestamp()));
    }

    public static Collector.Type getUnknownType() {
        Collector.Type unknownType;
        try {
            unknownType = Collector.Type.valueOf((String)"UNKNOWN");
        }
        catch (IllegalArgumentException e) {
            unknownType = Collector.Type.valueOf((String)"UNTYPED");
        }
        return unknownType;
    }

    public List<Collector.MetricFamilySamples> describe() {
        return this.collect();
    }

    public void close() {
        this.server.stop();
    }
}

