/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;

public class Id {
    private final UUID id = UUID.randomUUID();
    private final String name;
    private final SortedMap<String, String> tags;

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Iterable<Map.Entry<String, String>> getTags() {
        return this.tags.entrySet();
    }

    public int getTagCount() {
        return this.tags.size();
    }

    public Id(String name) {
        this.name = name;
        this.tags = new TreeMap<String, String>();
    }

    public Id withTag(String name, String value) {
        this.tags.put(name, value);
        return this;
    }

    public Id withTag(Iterable<Map.Entry<String, String>> tags) {
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags) {
                this.tags.put(tag.getKey(), tag.getValue());
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("(");
        if (this.tags.size() == 0) {
            builder.append(")");
            return builder.toString();
        }
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            builder.append(String.format("%s=%s,", tag.getKey(), tag.getValue()));
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")");
        return builder.toString();
    }
}

