/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.http;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XidResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(XidResource.class);

    public static void cleanXid(String rpcXid) {
        String xid = RootContext.getXID();
        if (StringUtils.isNotBlank((String)xid)) {
            String unbindXid = RootContext.unbind();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unbind[{}] from RootContext", (Object)unbindXid);
            }
            if (!StringUtils.equalsIgnoreCase((String)rpcXid, (String)unbindXid)) {
                LOGGER.warn("xid in change during RPC from {} to {}", (Object)rpcXid, (Object)unbindXid);
                if (StringUtils.isNotBlank((String)unbindXid)) {
                    RootContext.bind((String)unbindXid);
                    LOGGER.warn("bind [{}] back to RootContext", (Object)unbindXid);
                }
            }
        }
    }
}

