/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import io.netty.util.internal.ConcurrentSet;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsulConfiguration
extends AbstractConfiguration {
    private static volatile ConsulConfiguration instance;
    private static volatile ConsulClient client;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "consul";
    private static final String ACL_TOKEN = "aclToken";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.consul.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ExecutorService consulNotifierExecutor;
    private ConcurrentMap<String, Set<ConfigurationChangeListener>> configListenersMap = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
    private static final int DEFAULT_WATCH_TIMEOUT = 60;
    private static final long CAS = 0L;

    private ConsulConfiguration() {
        this.consulNotifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("consul-config-executor", 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsulConfiguration getInstance() {
        if (instance != null) return instance;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (instance != null) return instance;
            instance = new ConsulConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().getKVValue(dataId, ConsulConfiguration.getAclToken()), configFuture));
        return (String)configFuture.get();
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content, ConsulConfiguration.getAclToken(), null), configFuture));
        return (Boolean)configFuture.get();
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.consulNotifierExecutor.execute(() -> {
            PutParams putParams = new PutParams();
            putParams.setCas(Long.valueOf(0L));
            this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content, ConsulConfiguration.getAclToken(), putParams), configFuture);
        });
        return (Boolean)configFuture.get();
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().deleteKVValue(dataId, ConsulConfiguration.getAclToken()), configFuture));
        return (Boolean)configFuture.get();
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        ConsulListener consulListener = new ConsulListener(dataId, listener);
        this.configListenersMap.computeIfAbsent(dataId, key -> new ConcurrentSet()).add(consulListener);
        consulListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            for (ConfigurationChangeListener entry : configListeners) {
                ConfigurationChangeListener target = ((ConsulListener)entry).getTargetListener();
                if (!listener.equals(target)) continue;
                entry.onShutDown();
                configListeners.remove(entry);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)this.configListenersMap.get(dataId);
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConsulClient getConsulClient() {
        if (client != null) return client;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (client != null) return client;
            String serverAddr = FILE_CONFIG.getConfig("config.consul.serverAddr");
            InetSocketAddress inetSocketAddress = NetUtil.toInetSocketAddress((String)serverAddr);
            client = new ConsulClient(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private static String getAclToken() {
        String aclToken = StringUtils.isNotBlank((String)System.getProperty(ACL_TOKEN)) ? System.getProperty(ACL_TOKEN) : FILE_CONFIG.getConfig("config.consul.aclToken");
        return StringUtils.isNotBlank((String)aclToken) ? aclToken : null;
    }

    private void complete(Response response, ConfigFuture configFuture) {
        if (response != null && response.getValue() != null) {
            Object value = response.getValue();
            if (value instanceof GetValue) {
                configFuture.setResult((Object)((GetValue)value).getDecodedValue());
            } else {
                configFuture.setResult(value);
            }
        }
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }

    public static class ConsulListener
    implements ConfigurationChangeListener {
        private final ConfigurationChangeListener listener;
        private final String dataId;
        private long consulIndex;
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("consulListener", 1));

        public ConsulListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
            this.consulIndex = ConsulConfiguration.getConsulClient().getKVValue(dataId, ConsulConfiguration.getAclToken()).getConsulIndex();
        }

        public void onChangeEvent(ConfigurationChangeEvent event) {
            if (this.listener != null) {
                while (true) {
                    QueryParams queryParams = new QueryParams(60L, this.consulIndex);
                    Response response = ConsulConfiguration.getConsulClient().getKVValue(this.dataId, ConsulConfiguration.getAclToken(), queryParams);
                    Long currentIndex = response.getConsulIndex();
                    if (currentIndex == null || currentIndex <= this.consulIndex) continue;
                    GetValue getValue = (GetValue)response.getValue();
                    this.consulIndex = currentIndex;
                    event.setDataId(this.dataId).setNewValue(getValue.getDecodedValue());
                    this.listener.onChangeEvent(event);
                }
            }
        }

        public ExecutorService getExecutorService() {
            return this.executor;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }
    }
}

