/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.oracle;

import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.Sequenceable;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="oracle", scope=Scope.PROTOTYPE)
public class OracleInsertExecutor
extends BaseInsertExecutor
implements Sequenceable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleInsertExecutor.class);

    public OracleInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        HashMap<String, List<Object>> pkValuesMap = new HashMap<String, List<Object>>(pkColumnNameList.size());
        if (!this.containsColumns() || this.containsAnyPk()) {
            pkValuesMap.putAll(this.getPkValuesByColumn());
        }
        for (String columnName : pkColumnNameList) {
            if (pkValuesMap.containsKey(columnName)) continue;
            pkValuesMap.put(columnName, this.getGeneratedKeys(columnName));
        }
        return pkValuesMap;
    }

    public boolean containsAnyPk() {
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        List<String> insertColumns = recognizer.getInsertColumns();
        if (CollectionUtils.isEmpty(insertColumns)) {
            return false;
        }
        List<String> pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        if (CollectionUtils.isEmpty(pkColumnNameList)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(insertColumns, this.getDbType());
        return pkColumnNameList.stream().anyMatch(pkColumn -> newColumns.contains(pkColumn) || CollectionUtils.toUpperList(newColumns).contains(pkColumn.toUpperCase()));
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        Set<String> keySet = pkValuesMap.keySet();
        for (String pkKey : keySet) {
            List<Object> pkValues = pkValuesMap.get(pkKey);
            for (int i = 0; i < pkValues.size(); ++i) {
                if (!pkKey.isEmpty() && pkValues.get(i) instanceof SqlSequenceExpr) {
                    pkValues.set(i, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(i), pkKey).get(0));
                    continue;
                }
                if (!pkKey.isEmpty() && pkValues.get(i) instanceof SqlMethodExpr) {
                    pkValues.set(i, this.getGeneratedKeys(pkKey).get(0));
                    continue;
                }
                if (pkKey.isEmpty() || !(pkValues.get(i) instanceof Null)) continue;
                pkValues.set(i, this.getGeneratedKeys(pkKey).get(0));
            }
            pkValuesMap.put(pkKey, pkValues);
        }
        return pkValuesMap;
    }

    @Override
    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT " + expr.getSequence() + ".currval FROM DUAL";
    }
}

