/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.interceptor.handler;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.event.EventBus;
import io.seata.core.event.GuavaEventBus;
import io.seata.core.exception.TmTransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.GlobalLockConfig;
import io.seata.integration.tx.api.annotation.AspectTransactional;
import io.seata.integration.tx.api.event.DegradeCheckEvent;
import io.seata.integration.tx.api.interceptor.InvocationWrapper;
import io.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import io.seata.integration.tx.api.interceptor.handler.AbstractProxyInvocationHandler;
import io.seata.integration.tx.api.util.ClassUtils;
import io.seata.rm.GlobalLockExecutor;
import io.seata.rm.GlobalLockTemplate;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.tm.TransactionManagerHolder;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.FailureHandlerHolder;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTransactionalInterceptorHandler
extends AbstractProxyInvocationHandler
implements ConfigurationChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionalInterceptorHandler.class);
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final GlobalLockTemplate globalLockTemplate = new GlobalLockTemplate();
    private Set<String> methodsToProxy;
    private volatile boolean disable;
    private static final AtomicBoolean ATOMIC_DEGRADE_CHECK = new AtomicBoolean(false);
    private static volatile Integer degradeNum = 0;
    private static volatile Integer reachNum = 0;
    private static int degradeCheckAllowTimes;
    protected AspectTransactional aspectTransactional;
    private static int degradeCheckPeriod;
    private static int defaultGlobalTransactionTimeout;
    private final FailureHandler failureHandler;
    private static final EventBus EVENT_BUS;
    private static volatile ScheduledThreadPoolExecutor executor;

    private void initDefaultGlobalTransactionTimeout() {
        if (defaultGlobalTransactionTimeout <= 0) {
            int defaultGlobalTransactionTimeout;
            try {
                defaultGlobalTransactionTimeout = ConfigurationFactory.getInstance().getInt("client.tm.defaultGlobalTransactionTimeout", 60000);
            }
            catch (Exception e) {
                LOGGER.error("Illegal global transaction timeout value: " + e.getMessage());
                defaultGlobalTransactionTimeout = 60000;
            }
            if (defaultGlobalTransactionTimeout <= 0) {
                LOGGER.warn("Global transaction timeout value '{}' is illegal, and has been reset to the default value '{}'", (Object)defaultGlobalTransactionTimeout, (Object)60000);
                defaultGlobalTransactionTimeout = 60000;
            }
            GlobalTransactionalInterceptorHandler.defaultGlobalTransactionTimeout = defaultGlobalTransactionTimeout;
        }
    }

    public GlobalTransactionalInterceptorHandler(FailureHandler failureHandler, Set<String> methodsToProxy) {
        this.failureHandler = failureHandler == null ? FailureHandlerHolder.getFailureHandler() : failureHandler;
        this.methodsToProxy = methodsToProxy;
        this.disable = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
        boolean degradeCheck = ConfigurationFactory.getInstance().getBoolean("client.tm.degradeCheck", false);
        degradeCheckPeriod = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckPeriod", 2000);
        degradeCheckAllowTimes = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckAllowTimes", 10);
        EVENT_BUS.register(this);
        if (degradeCheck && degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
            GlobalTransactionalInterceptorHandler.startDegradeCheck();
        }
        ConfigurationCache.addConfigListener("client.tm.degradeCheck", this);
        this.initDefaultGlobalTransactionTimeout();
    }

    public GlobalTransactionalInterceptorHandler(FailureHandler failureHandler, Set<String> methodsToProxy, AspectTransactional aspectTransactional) {
        this(failureHandler, methodsToProxy);
        this.aspectTransactional = aspectTransactional;
    }

    @Override
    protected Object doInvoke(InvocationWrapper invocation) throws Throwable {
        Class<?> targetClass = invocation.getTarget().getClass();
        Method specificMethod = ClassUtils.getMostSpecificMethod(invocation.getMethod(), targetClass);
        if (specificMethod != null && !specificMethod.getDeclaringClass().equals(Object.class)) {
            boolean localDisable;
            GlobalTransactional globalTransactionalAnnotation = this.getAnnotation(specificMethod, targetClass, GlobalTransactional.class);
            GlobalLock globalLockAnnotation = this.getAnnotation(specificMethod, targetClass, GlobalLock.class);
            boolean bl = localDisable = this.disable || ATOMIC_DEGRADE_CHECK.get() && degradeNum >= degradeCheckAllowTimes;
            if (!localDisable) {
                if (globalTransactionalAnnotation != null || this.aspectTransactional != null) {
                    AspectTransactional transactional = globalTransactionalAnnotation != null ? new AspectTransactional(globalTransactionalAnnotation.timeoutMills(), globalTransactionalAnnotation.name(), globalTransactionalAnnotation.rollbackFor(), globalTransactionalAnnotation.rollbackForClassName(), globalTransactionalAnnotation.noRollbackFor(), globalTransactionalAnnotation.noRollbackForClassName(), globalTransactionalAnnotation.propagation(), globalTransactionalAnnotation.lockRetryInterval(), globalTransactionalAnnotation.lockRetryTimes(), globalTransactionalAnnotation.lockStrategyMode()) : this.aspectTransactional;
                    return this.handleGlobalTransaction(invocation, transactional);
                }
                if (globalLockAnnotation != null) {
                    return this.handleGlobalLock(invocation, globalLockAnnotation);
                }
            }
        }
        return invocation.proceed();
    }

    private Object handleGlobalLock(final InvocationWrapper methodInvocation, final GlobalLock globalLockAnno) throws Throwable {
        return this.globalLockTemplate.execute(new GlobalLockExecutor(){

            @Override
            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            @Override
            public GlobalLockConfig getGlobalLockConfig() {
                GlobalLockConfig config = new GlobalLockConfig();
                config.setLockRetryInterval(globalLockAnno.lockRetryInterval());
                config.setLockRetryTimes(globalLockAnno.lockRetryTimes());
                return config;
            }
        });
    }

    Object handleGlobalTransaction(final InvocationWrapper methodInvocation, final AspectTransactional aspectTransactional) throws Throwable {
        boolean succeed = true;
        try {
            Object object = this.transactionalTemplate.execute(new TransactionalExecutor(){

                @Override
                public Object execute() throws Throwable {
                    return methodInvocation.proceed();
                }

                public String name() {
                    String name = aspectTransactional.getName();
                    if (!StringUtils.isNullOrEmpty(name)) {
                        return name;
                    }
                    return GlobalTransactionalInterceptorHandler.this.formatMethod(methodInvocation.getMethod());
                }

                @Override
                public TransactionInfo getTransactionInfo() {
                    int timeout = aspectTransactional.getTimeoutMills();
                    if (timeout <= 0 || timeout == 60000) {
                        timeout = defaultGlobalTransactionTimeout;
                    }
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(timeout);
                    transactionInfo.setName(this.name());
                    transactionInfo.setPropagation(aspectTransactional.getPropagation());
                    transactionInfo.setLockRetryInterval(aspectTransactional.getLockRetryInterval());
                    transactionInfo.setLockRetryTimes(aspectTransactional.getLockRetryTimes());
                    transactionInfo.setLockStrategyMode(aspectTransactional.getLockStrategyMode());
                    LinkedHashSet<RollbackRule> rollbackRules = new LinkedHashSet<RollbackRule>();
                    for (Class<? extends Throwable> clazz : aspectTransactional.getRollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getRollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class<? extends Throwable> clazz : aspectTransactional.getNoRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getNoRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
            return object;
        }
        catch (TransactionalExecutor.ExecutionException e) {
            GlobalTransaction globalTransaction = e.getTransaction();
            if (globalTransaction.getGlobalTransactionRole() == GlobalTransactionRole.Participant) {
                throw e.getOriginalException();
            }
            TransactionalExecutor.Code code = e.getCode();
            Throwable cause = e.getCause();
            boolean timeout = this.isTimeoutException(cause);
            switch (code) {
                case RollbackDone: {
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    succeed = false;
                    this.failureHandler.onBeginFailure(globalTransaction, cause);
                    throw cause;
                }
                case CommitFailure: {
                    succeed = false;
                    this.failureHandler.onCommitFailure(globalTransaction, cause);
                    throw cause;
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(globalTransaction, e.getOriginalException());
                    throw e.getOriginalException();
                }
                case Rollbacking: {
                    this.failureHandler.onRollbacking(globalTransaction, e.getOriginalException());
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
            }
            throw new ShouldNeverHappenException(String.format("Unknown TransactionalExecutor.Code: %s", new Object[]{code}), e.getOriginalException());
        }
        finally {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                EVENT_BUS.post(new DegradeCheckEvent(succeed));
            }
        }
    }

    public <T extends Annotation> T getAnnotation(Method method, Class<?> targetClass, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(method).map(m -> m.getAnnotation(annotationClass)).orElse(Optional.ofNullable(targetClass).map(t -> t.getAnnotation(annotationClass)).orElse(null)));
    }

    private String formatMethod(Method method) {
        StringBuilder sb = new StringBuilder(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(", ");
        }
        return sb.append(")").toString();
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disable, event.getNewValue()});
            this.disable = Boolean.parseBoolean(event.getNewValue().trim());
        } else if ("client.tm.degradeCheck".equals(event.getDataId())) {
            boolean degradeCheck = Boolean.parseBoolean(event.getNewValue());
            if (!degradeCheck) {
                degradeNum = 0;
                GlobalTransactionalInterceptorHandler.stopDegradeCheck();
            } else if (degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
                GlobalTransactionalInterceptorHandler.startDegradeCheck();
            }
        }
    }

    private static void stopDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(true, false)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
        }
    }

    private static void startDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(false, true)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            return;
        }
        executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("degradeCheckWorker", 1, true));
        executor.scheduleAtFixedRate(() -> {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                try {
                    String xid = TransactionManagerHolder.get().begin(null, null, "degradeCheck", 60000);
                    TransactionManagerHolder.get().commit(xid);
                    EVENT_BUS.post(new DegradeCheckEvent(true));
                }
                catch (Exception e) {
                    EVENT_BUS.post(new DegradeCheckEvent(false));
                }
            }
        }, degradeCheckPeriod, degradeCheckPeriod, TimeUnit.MILLISECONDS);
    }

    private boolean isTimeoutException(Throwable th) {
        TmTransactionException exx;
        if (null == th) {
            return false;
        }
        return th instanceof TmTransactionException && TransactionExceptionCode.TransactionTimeout == (exx = (TmTransactionException)th).getCode();
    }

    @Override
    public Set<String> getMethodsToProxy() {
        return this.methodsToProxy;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.BeforeTransaction;
    }

    static {
        defaultGlobalTransactionTimeout = 0;
        EVENT_BUS = new GuavaEventBus("degradeCheckEventBus", true);
    }
}

