/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.processor;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.config.processor.ConfigDataType;
import io.seata.config.processor.Processor;
import java.io.IOException;
import java.util.Properties;

public class ConfigProcessor {
    private static final String SEPARATOR = ".";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String DEFAULT_DATA_TYPE = "properties";

    public static Properties processConfig(String config, String dataType) throws IOException {
        return EnhancedServiceLoader.load(Processor.class, dataType).processor(config);
    }

    public static String resolverConfigDataType(String dataId) {
        return ConfigProcessor.resolverConfigDataType(FILE_CONFIG.getConfig(ConfigProcessor.getDataTypeKey()), dataId, DEFAULT_DATA_TYPE);
    }

    public static String resolverConfigDataType(String dataType, String dataId, String defaultDataType) {
        if (StringUtils.isNotBlank(dataType)) {
            return dataType;
        }
        if (!dataId.contains(SEPARATOR)) {
            return defaultDataType;
        }
        String[] splitString = dataId.split("\\.");
        try {
            ConfigDataType configDataType = ConfigDataType.getTypeBySuffix(splitString[splitString.length - 1]);
            return configDataType.name();
        }
        catch (IllegalArgumentException e) {
            return defaultDataType;
        }
    }

    private static String getDataTypeKey() {
        return String.join((CharSequence)SEPARATOR, "config", "dataType");
    }
}

