/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.mysql;

import com.google.common.base.Joiner;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.PreparedStatementProxy;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.mysql.MySQLInsertExecutor;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.sqlparser.SQLInsertRecognizer;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.struct.Defaultable;
import io.seata.sqlparser.struct.Null;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@LoadLevel(name="mysql", scope=Scope.PROTOTYPE)
public class MySQLInsertOrUpdateExecutor
extends MySQLInsertExecutor
implements Defaultable {
    private static final String COLUMN_SEPARATOR = "|";
    private boolean isUpdateFlag = false;
    private String selectSQL;
    private ArrayList<List<Object>> paramAppenderList;

    public String getSelectSQL() {
        return this.selectSQL;
    }

    public ArrayList<List<Object>> getParamAppenderList() {
        return this.paramAppenderList;
    }

    public MySQLInsertOrUpdateExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected Object executeAutoCommitFalse(Object[] args) throws Exception {
        if (!"mysql".equalsIgnoreCase(this.getDbType()) && this.getTableMeta().getPrimaryKeyOnlyName().size() > 1) {
            throw new NotSupportYetException("multi pk only support mysql!");
        }
        TableRecords beforeImage = this.beforeImage();
        if (CollectionUtils.isNotEmpty(beforeImage.getRows())) {
            this.isUpdateFlag = true;
        } else {
            beforeImage = TableRecords.empty(this.getTableMeta());
        }
        Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
        int updateCount = this.statementProxy.getUpdateCount();
        if (updateCount > 0) {
            TableRecords afterImage = this.afterImage(beforeImage);
            this.prepareUndoLogAll(beforeImage, afterImage);
        }
        return result;
    }

    protected void prepareUndoLogAll(TableRecords beforeImage, TableRecords afterImage) {
        if (beforeImage.getRows().isEmpty() && afterImage.getRows().isEmpty()) {
            return;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        TableRecords lockKeyRecords = afterImage;
        String lockKeys = this.buildLockKey(lockKeyRecords);
        connectionProxy.appendLockKey(lockKeys);
        this.buildUndoItemAll(connectionProxy, beforeImage, afterImage);
    }

    protected void buildUndoItemAll(ConnectionProxy connectionProxy, TableRecords beforeImage, TableRecords afterImage) {
        TableRecords partAfterImage;
        if (!this.isUpdateFlag) {
            SQLUndoLog sqlUndoLog = this.buildUndoItem(SQLType.INSERT, TableRecords.empty(this.getTableMeta()), afterImage);
            connectionProxy.appendUndoLog(sqlUndoLog);
            return;
        }
        List<Row> beforeImageRows = beforeImage.getRows();
        ArrayList<String> beforePrimaryValues = new ArrayList<String>();
        for (Row r : beforeImageRows) {
            String primaryValue = "";
            for (Field f : r.primaryKeys()) {
                primaryValue = primaryValue + f.getValue() + COLUMN_SEPARATOR;
            }
            beforePrimaryValues.add(primaryValue);
        }
        ArrayList<Row> insertRows = new ArrayList<Row>();
        ArrayList<Row> updateRows = new ArrayList<Row>();
        List<Row> afterImageRows = afterImage.getRows();
        for (Row r : afterImageRows) {
            String primaryValue = "";
            for (Field f : r.primaryKeys()) {
                primaryValue = primaryValue + f.getValue() + COLUMN_SEPARATOR;
            }
            if (beforePrimaryValues.contains(primaryValue)) {
                updateRows.add(r);
                continue;
            }
            insertRows.add(r);
        }
        if (CollectionUtils.isNotEmpty(updateRows)) {
            partAfterImage = new TableRecords(afterImage.getTableMeta());
            partAfterImage.setTableName(afterImage.getTableName());
            partAfterImage.setRows(updateRows);
            if (beforeImage.getRows().size() != partAfterImage.getRows().size()) {
                throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
            }
            connectionProxy.appendUndoLog(this.buildUndoItem(SQLType.UPDATE, beforeImage, partAfterImage));
        }
        if (CollectionUtils.isNotEmpty(insertRows)) {
            partAfterImage = new TableRecords(afterImage.getTableMeta());
            partAfterImage.setTableName(afterImage.getTableName());
            partAfterImage.setRows(insertRows);
            connectionProxy.appendUndoLog(this.buildUndoItem(SQLType.INSERT, TableRecords.empty(this.getTableMeta()), partAfterImage));
        }
    }

    protected SQLUndoLog buildUndoItem(SQLType sqlType, TableRecords beforeImage, TableRecords afterImage) {
        String tableName = this.sqlRecognizer.getTableName();
        SQLUndoLog sqlUndoLog = new SQLUndoLog();
        sqlUndoLog.setSqlType(sqlType);
        sqlUndoLog.setTableName(tableName);
        sqlUndoLog.setBeforeImage(beforeImage);
        sqlUndoLog.setAfterImage(afterImage);
        return sqlUndoLog;
    }

    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableMeta tmeta = this.getTableMeta();
        List<Row> rows = beforeImage.getRows();
        HashMap<String, ArrayList> primaryValueMap = new HashMap<String, ArrayList>();
        rows.forEach(m -> {
            List<Field> fields = m.primaryKeys();
            fields.forEach(f -> {
                ArrayList values = primaryValueMap.computeIfAbsent(f.getName(), v -> new ArrayList());
                values.add(f.getValue());
            });
        });
        StringBuilder afterImageSql = new StringBuilder(this.selectSQL);
        int i = 0;
        while (i < rows.size()) {
            int finalI = i++;
            ArrayList wherePrimaryList = new ArrayList();
            primaryValueMap.forEach((k, v) -> wherePrimaryList.add(k + " = " + ((ArrayList)primaryValueMap.get(k)).get(finalI) + " "));
            afterImageSql.append(" OR (").append(Joiner.on((String)" and ").join(wherePrimaryList)).append(") ");
        }
        return this.buildTableRecords2(tmeta, afterImageSql.toString(), this.paramAppenderList);
    }

    @Override
    public TableRecords beforeImage() throws SQLException {
        TableMeta tmeta = this.getTableMeta();
        if (StringUtils.isBlank(this.selectSQL)) {
            this.paramAppenderList = new ArrayList();
            this.selectSQL = this.buildImageSQL(tmeta);
        }
        return this.buildTableRecords2(tmeta, this.selectSQL, this.paramAppenderList);
    }

    /*
     * Exception decompiling
     */
    public TableRecords buildTableRecords2(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String buildImageSQL(TableMeta tableMeta) {
        if (CollectionUtils.isEmpty(this.paramAppenderList)) {
            this.paramAppenderList = new ArrayList();
        }
        SQLInsertRecognizer recognizer = (SQLInsertRecognizer)this.sqlRecognizer;
        int insertNum = recognizer.getInsertParamsValue().size();
        Map<String, ArrayList<Object>> imageParamperterMap = this.buildImageParamperters(recognizer);
        StringBuilder prefix = new StringBuilder("SELECT * ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        boolean[] isContainWhere = new boolean[]{false};
        int i = 0;
        while (i < insertNum) {
            int finalI = i++;
            ArrayList paramAppenderTempList = new ArrayList();
            tableMeta.getAllIndexes().forEach((k, v) -> {
                if (!v.isNonUnique()) {
                    boolean columnIsNull = true;
                    ArrayList<String> uniqueList = new ArrayList<String>();
                    for (ColumnMeta m : v.getValues()) {
                        String columnName = m.getColumnName();
                        if (imageParamperterMap.get(columnName) == null && m.getColumnDef() != null) {
                            uniqueList.add(columnName + " = DEFAULT(" + columnName + ") ");
                            columnIsNull = false;
                            continue;
                        }
                        if (imageParamperterMap.get(columnName) == null && m.getColumnDef() == null || ((ArrayList)imageParamperterMap.get(columnName)).get(finalI) == null || ((ArrayList)imageParamperterMap.get(columnName)).get(finalI) instanceof Null) {
                            if ("PRIMARY".equalsIgnoreCase((String)k)) break;
                            columnIsNull = false;
                            uniqueList.add(columnName + " is ? ");
                            paramAppenderTempList.add("NULL");
                            continue;
                        }
                        columnIsNull = false;
                        uniqueList.add(columnName + " = ? ");
                        paramAppenderTempList.add(((ArrayList)imageParamperterMap.get(columnName)).get(finalI));
                    }
                    if (!columnIsNull) {
                        if (isContainWhere[0]) {
                            suffix.append(" OR (").append(Joiner.on((String)" and ").join(uniqueList)).append(") ");
                        } else {
                            suffix.append(" WHERE (").append(Joiner.on((String)" and ").join(uniqueList)).append(") ");
                            isContainWhere[0] = true;
                        }
                    }
                }
            });
            this.paramAppenderList.add(paramAppenderTempList);
        }
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix.toString(), suffix.toString());
        return selectSQLJoin.toString();
    }

    public Map<String, ArrayList<Object>> buildImageParamperters(SQLInsertRecognizer recognizer) {
        List<String> duplicateKeyUpdateCloms = recognizer.getDuplicateKeyUpdate();
        if (CollectionUtils.isNotEmpty(duplicateKeyUpdateCloms)) {
            this.getTableMeta().getAllIndexes().forEach((k, v) -> {
                if ("PRIMARY".equalsIgnoreCase((String)k)) {
                    for (ColumnMeta m : v.getValues()) {
                        if (!duplicateKeyUpdateCloms.contains(m.getColumnName())) continue;
                        throw new ShouldNeverHappenException("update pk value is not supported!");
                    }
                }
            });
        }
        HashMap<String, ArrayList<Object>> imageParamperterMap = new HashMap<String, ArrayList<Object>>();
        Map<Integer, ArrayList<Object>> parameters = ((PreparedStatementProxy)this.statementProxy).getParameters();
        List<String> insertParamsList = recognizer.getInsertParamsValue();
        List<String> insertColumns = recognizer.getInsertColumns();
        int paramsindex = 1;
        for (String insertParams : insertParamsList) {
            String[] insertParamsArray = insertParams.split(",");
            for (int i = 0; i < insertColumns.size(); ++i) {
                String m = insertColumns.get(i);
                String params = insertParamsArray[i];
                ArrayList imageListTemp = imageParamperterMap.computeIfAbsent(m, k -> new ArrayList());
                if ("?".equals(params.trim())) {
                    ArrayList<Object> objects = parameters.get(paramsindex);
                    imageListTemp.addAll(objects);
                    ++paramsindex;
                } else if (params instanceof String) {
                    if (params.trim().startsWith("'") && params.trim().endsWith("'") || params.trim().startsWith("\"") && params.trim().endsWith("\"")) {
                        params = params.trim();
                        params = params.substring(1, params.length() - 1);
                    }
                    imageListTemp.add(params);
                } else {
                    imageListTemp.add(params);
                }
                imageParamperterMap.put(m, imageListTemp);
            }
        }
        return imageParamperterMap;
    }
}

