/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.util;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.MySqlUtils;
import com.alibaba.druid.util.PGUtils;
import io.seata.rm.BaseDataSourceResource;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAUtils.class);

    public static String getDbType(String jdbcUrl, String driverClassName) {
        return JdbcUtils.getDbType((String)jdbcUrl, (String)driverClassName);
    }

    public static XAConnection createXAConnection(Connection physicalConn, BaseDataSourceResource dataSourceResource) throws SQLException {
        return XAUtils.createXAConnection(physicalConn, dataSourceResource.getDriver(), dataSourceResource.getDbType());
    }

    public static XAConnection createXAConnection(Connection physicalConn, Driver driver, String dbType) throws SQLException {
        if ("oracle".equals(dbType)) {
            try {
                String physicalConnClassName = physicalConn.getClass().getName();
                if ("oracle.jdbc.driver.T4CConnection".equals(physicalConnClassName)) {
                    return XAUtils.createOracleXAConnection(physicalConn, "oracle.jdbc.driver.T4CXAConnection");
                }
                return XAUtils.createOracleXAConnection(physicalConn, "oracle.jdbc.xa.client.OracleXAConnection");
            }
            catch (XAException xae) {
                throw new SQLException("create xaConnection error", xae);
            }
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType)) {
            return MySqlUtils.createXAConnection((Driver)driver, (Connection)physicalConn);
        }
        if ("postgresql".equals(dbType)) {
            return PGUtils.createXAConnection((Connection)physicalConn);
        }
        throw new SQLException("xa not support dbType: " + dbType);
    }

    private static XAConnection createOracleXAConnection(Connection physicalConnection, String xaConnectionClassName) throws XAException, SQLException {
        try {
            Class<?> xaConnectionClass = Class.forName(xaConnectionClassName);
            Constructor<?> constructor = xaConnectionClass.getConstructor(Connection.class);
            constructor.setAccessible(true);
            return (XAConnection)constructor.newInstance(physicalConnection);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create Oracle XA Connection " + xaConnectionClassName + " on " + physicalConnection);
            if (e instanceof XAException) {
                throw (XAException)e;
            }
            throw new SQLException(e);
        }
    }
}

