/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.core.model.BranchType;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.spring.annotation.datasource.DataSourceProxyHolder;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SeataDataSourceBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataDataSourceBeanPostProcessor.class);
    private final List<String> excludes;
    private final BranchType dataSourceProxyMode;

    public SeataDataSourceBeanPostProcessor(String[] excludes, String dataSourceProxyMode) {
        this.excludes = Arrays.asList(excludes);
        this.dataSourceProxyMode = BranchType.XA.name().equalsIgnoreCase(dataSourceProxyMode) ? BranchType.XA : BranchType.AT;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            if (!this.excludes.contains(bean.getClass().getName())) {
                DataSourceProxyHolder.get().putDataSource((DataSource)bean, this.dataSourceProxyMode);
            }
            if (bean instanceof SeataDataSourceProxy) {
                LOGGER.info("Unwrap the bean of the data source, and return the original data source to replace the data source proxy.");
                return ((SeataDataSourceProxy)bean).getTargetDataSource();
            }
        }
        return bean;
    }
}

