/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.tcc;

import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionInterceptorHandler;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.DubboUtil;
import io.seata.spring.util.SpringProxyUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TccActionInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccActionInterceptor.class);
    private ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    protected RemotingDesc remotingDesc;

    public TccActionInterceptor() {
    }

    public TccActionInterceptor(RemotingDesc remotingDesc) {
        this.remotingDesc = remotingDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!RootContext.inGlobalTransaction()) {
            return invocation.proceed();
        }
        Method method = this.getActionInterfaceMethod(invocation);
        TwoPhaseBusinessAction businessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            RootContext.unbind();
            RootContext.bindInterceptorType(xid, BranchType.TCC);
            try {
                Object[] methodArgs = invocation.getArguments();
                Map<String, Object> ret = this.actionInterceptorHandler.proceed(method, methodArgs, xid, businessAction, () -> ((MethodInvocation)invocation).proceed());
                Object object = ret.get("result");
                return object;
            }
            finally {
                RootContext.unbindInterceptorType();
                RootContext.bind(xid);
            }
        }
        return invocation.proceed();
    }

    protected Method getActionInterfaceMethod(MethodInvocation invocation) {
        try {
            Class<?> interfaceType = this.remotingDesc == null ? this.getProxyInterface(invocation.getThis()) : this.remotingDesc.getInterfaceClass();
            if (interfaceType == null && this.remotingDesc.getInterfaceClassName() != null) {
                interfaceType = Class.forName(this.remotingDesc.getInterfaceClassName(), true, Thread.currentThread().getContextClassLoader());
            }
            if (interfaceType == null) {
                return invocation.getMethod();
            }
            return interfaceType.getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
        }
        catch (Exception e) {
            LOGGER.warn("get Method from interface failed", (Throwable)e);
            return invocation.getMethod();
        }
    }

    protected Class<?> getProxyInterface(Object proxyBean) throws Exception {
        if (DubboUtil.isDubboProxyName(proxyBean.getClass().getName())) {
            return DubboUtil.getAssistInterface(proxyBean);
        }
        return SpringProxyUtils.getTargetInterface(proxyBean);
    }
}

