/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.CollectionUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.DeleteExecutor;
import io.seata.rm.datasource.exec.Executor;
import io.seata.rm.datasource.exec.InsertExecutor;
import io.seata.rm.datasource.exec.MultiExecutor;
import io.seata.rm.datasource.exec.PlainExecutor;
import io.seata.rm.datasource.exec.SelectForUpdateExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.rm.datasource.sql.SQLVisitorFactory;
import io.seata.sqlparser.SQLRecognizer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ExecuteTemplate {
    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(List<SQLRecognizer> sqlRecognizers, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        Object rs;
        Executor executor;
        if (!RootContext.inGlobalTransaction() && !RootContext.requireGlobalLock()) {
            return statementCallback.execute(statementProxy.getTargetStatement(), args);
        }
        if (sqlRecognizers == null) {
            sqlRecognizers = SQLVisitorFactory.get(statementProxy.getTargetSQL(), statementProxy.getConnectionProxy().getDbType());
        }
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else if (sqlRecognizers.size() == 1) {
            SQLRecognizer sqlRecognizer = sqlRecognizers.get(0);
            switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = new InsertExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case UPDATE: {
                    executor = new UpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    executor = new DeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    executor = new SelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                    break;
                }
            }
        } else {
            executor = new MultiExecutor<T, S>(statementProxy, statementCallback, sqlRecognizers);
        }
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex2) {
            SQLException ex2;
            if (!(ex2 instanceof SQLException)) {
                ex2 = new SQLException(ex2);
            }
            throw (SQLException)ex2;
        }
        return rs;
    }
}

