/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.HeartbeatMessage;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.protocol.RpcMessage;
import io.seata.core.rpc.ChannelManager;
import io.seata.core.rpc.RpcContext;
import io.seata.core.rpc.ServerMessageListener;
import io.seata.core.rpc.ServerMessageSender;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.AbstractRpcRemoting;
import io.seata.core.rpc.netty.NettyServerConfig;
import io.seata.core.rpc.netty.RegisterCheckAuthHandler;
import io.seata.core.rpc.netty.RpcServerBootstrap;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcRemotingServer
extends AbstractRpcRemoting
implements ServerMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRpcRemotingServer.class);
    private final RpcServerBootstrap serverBootstrap;
    private ServerMessageListener serverMessageListener;
    private TransactionMessageHandler transactionMessageHandler;
    private RegisterCheckAuthHandler checkAuthHandler;

    public AbstractRpcRemotingServer(ThreadPoolExecutor messageExecutor, NettyServerConfig nettyServerConfig) {
        super(messageExecutor);
        this.serverBootstrap = new RpcServerBootstrap(nettyServerConfig);
    }

    public void setHandler(TransactionMessageHandler transactionMessageHandler) {
        this.setHandler(transactionMessageHandler, null);
    }

    private void setHandler(TransactionMessageHandler transactionMessageHandler, RegisterCheckAuthHandler checkAuthHandler) {
        this.transactionMessageHandler = transactionMessageHandler;
        this.checkAuthHandler = checkAuthHandler;
    }

    public TransactionMessageHandler getTransactionMessageHandler() {
        return this.transactionMessageHandler;
    }

    public RegisterCheckAuthHandler getCheckAuthHandler() {
        return this.checkAuthHandler;
    }

    public void setServerMessageListener(ServerMessageListener serverMessageListener) {
        this.serverMessageListener = serverMessageListener;
    }

    public ServerMessageListener getServerMessageListener() {
        return this.serverMessageListener;
    }

    public void setChannelHandlers(ChannelHandler ... handlers) {
        this.serverBootstrap.setChannelHandlers(handlers);
    }

    public void setListenPort(int listenPort) {
        this.serverBootstrap.setListenPort(listenPort);
    }

    public int getListenPort() {
        return this.serverBootstrap.getListenPort();
    }

    @Override
    public void init() {
        super.init();
        this.serverBootstrap.start();
    }

    @Override
    public void destroy() {
        this.serverBootstrap.shutdown();
        super.destroy();
    }

    public void debugLog(String info) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(info);
        }
    }

    private void closeChannelHandlerContext(ChannelHandlerContext ctx) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("closeChannelHandlerContext channel:" + ctx.channel());
        }
        ctx.disconnect();
        ctx.close();
    }

    @Override
    public void destroyChannel(String serverAddress, Channel channel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will destroy channel:{},address:{}", (Object)channel, (Object)serverAddress);
        }
        channel.disconnect();
        channel.close();
    }

    @ChannelHandler.Sharable
    class ServerHandler
    extends AbstractRpcRemoting.AbstractHandler {
        ServerHandler() {
        }

        @Override
        public void dispatch(RpcMessage request, ChannelHandlerContext ctx) {
            Object msg = request.getBody();
            if (msg instanceof RegisterRMRequest) {
                AbstractRpcRemotingServer.this.serverMessageListener.onRegRmMessage(request, ctx, AbstractRpcRemotingServer.this.checkAuthHandler);
            } else if (ChannelManager.isRegistered(ctx.channel())) {
                AbstractRpcRemotingServer.this.serverMessageListener.onTrxMessage(request, ctx);
            } else {
                try {
                    AbstractRpcRemotingServer.this.closeChannelHandlerContext(ctx);
                }
                catch (Exception exx) {
                    LOGGER.error(exx.getMessage());
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("close a unhandled connection! [%s]", ctx.channel().toString()));
                }
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof RpcMessage) {
                RpcMessage rpcMessage = (RpcMessage)msg;
                AbstractRpcRemotingServer.this.debugLog("read:" + rpcMessage.getBody());
                if (rpcMessage.getBody() instanceof RegisterTMRequest) {
                    AbstractRpcRemotingServer.this.serverMessageListener.onRegTmMessage(rpcMessage, ctx, AbstractRpcRemotingServer.this.checkAuthHandler);
                    return;
                }
                if (rpcMessage.getBody() == HeartbeatMessage.PING) {
                    AbstractRpcRemotingServer.this.serverMessageListener.onCheckMessage(rpcMessage, ctx);
                    return;
                }
            }
            super.channelRead(ctx, msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            AbstractRpcRemotingServer.this.debugLog("inactive:" + ctx);
            if (AbstractRpcRemotingServer.this.messageExecutor.isShutdown()) {
                return;
            }
            this.handleDisconnect(ctx);
            super.channelInactive(ctx);
        }

        private void handleDisconnect(ChannelHandlerContext ctx) {
            String ipAndPort = NetUtil.toStringAddress(ctx.channel().remoteAddress());
            RpcContext rpcContext = ChannelManager.getContextFromIdentified(ctx.channel());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(ipAndPort + " to server channel inactive.");
            }
            if (null != rpcContext && null != rpcContext.getClientRole()) {
                rpcContext.release();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("remove channel:" + ctx.channel() + "context:" + rpcContext);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("remove unused channel:" + ctx.channel());
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("channel exx:" + cause.getMessage() + ",channel:" + ctx.channel());
            }
            ChannelManager.releaseRpcContext(ctx.channel());
            super.exceptionCaught(ctx, cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof IdleStateEvent) {
                AbstractRpcRemotingServer.this.debugLog("idle:" + evt);
                IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
                if (idleStateEvent.state() == IdleState.READER_IDLE) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("channel:" + ctx.channel() + " read idle.");
                    }
                    this.handleDisconnect(ctx);
                    try {
                        AbstractRpcRemotingServer.this.closeChannelHandlerContext(ctx);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        }
    }
}

