/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.seata.common.util.StringUtils;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import io.seata.saga.statelang.domain.impl.BaseState;
import io.seata.saga.statelang.domain.impl.StateMachineImpl;
import io.seata.saga.statelang.parser.StateMachineParser;
import io.seata.saga.statelang.parser.StateParser;
import io.seata.saga.statelang.parser.StateParserFactory;
import java.util.Map;

public class StateMachineParserImpl
implements StateMachineParser {
    @Override
    public StateMachine parse(String json) {
        Map node = (Map)JSON.parseObject((String)json, Map.class, (Feature[])new Feature[]{Feature.IgnoreAutoType, Feature.OrderedField});
        StateMachineImpl stateMachine = new StateMachineImpl();
        stateMachine.setName((String)node.get("Name"));
        stateMachine.setComment((String)node.get("Comment"));
        stateMachine.setVersion((String)node.get("Version"));
        stateMachine.setStartState((String)node.get("StartState"));
        if ("false".equals(node.get("IsPersist"))) {
            stateMachine.setPersist(false);
        }
        Map statesNode = (Map)node.get("States");
        for (String stateName : statesNode.keySet()) {
            Map stateNode = (Map)statesNode.get(stateName);
            String stateType = (String)stateNode.get("Type");
            StateParser stateParser = StateParserFactory.getStateParser(stateType);
            if (stateParser == null) {
                throw new IllegalArgumentException("State Type [" + stateType + "] is not support");
            }
            Object state = stateParser.parse(stateNode);
            if (state instanceof BaseState) {
                ((BaseState)state).setName(stateName);
            }
            if (stateMachine.getState(stateName) != null) {
                throw new IllegalArgumentException("State[name:" + stateName + "] is already exists");
            }
            stateMachine.putState(stateName, (State)state);
        }
        Map<String, State> stateMap = stateMachine.getStates();
        for (String name : stateMap.keySet()) {
            AbstractTaskState taskState;
            State state = stateMap.get(name);
            if (!(state instanceof AbstractTaskState) || !StringUtils.isNotBlank((taskState = (AbstractTaskState)state).getCompensateState())) continue;
            taskState.setForUpdate(true);
            State compState = stateMap.get(taskState.getCompensateState());
            if (compState == null || !(compState instanceof AbstractTaskState)) continue;
            ((AbstractTaskState)compState).setForCompensation(true);
        }
        return stateMachine;
    }
}

