/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.LockDO;
import io.seata.core.store.LockStore;
import io.seata.core.store.db.LockStoreSqls;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db")
public class LockStoreDataBaseDAO
implements LockStore,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockStoreDataBaseDAO.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource logStoreDataSource = null;
    protected String lockTable;
    protected String dbType;

    public LockStoreDataBaseDAO(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    @Override
    public void init() {
        this.lockTable = CONFIG.getConfig("store.db.lock-table", "lock_table");
        this.dbType = CONFIG.getConfig("store.db.db-type");
        if (StringUtils.isBlank(this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (this.logStoreDataSource == null) {
            throw new StoreException("there must be logStoreDataSource.");
        }
    }

    @Override
    public boolean acquireLock(LockDO lockDO) {
        return this.acquireLock(Collections.singletonList(lockDO));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean acquireLock(List<LockDO> lockDOs) {
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        List<LockDO> unrepeatedLockDOs = null;
        HashSet<String> dbExistedRowKeys = new HashSet<String>();
        boolean originalAutoCommit = true;
        try {
            conn = this.logStoreDataSource.getConnection();
            originalAutoCommit = conn.getAutoCommit();
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lockDOs.size(); ++i) {
                sb.append("?");
                if (i == lockDOs.size() - 1) continue;
                sb.append(", ");
            }
            boolean canLock = true;
            String checkLockSQL = LockStoreSqls.getCheckLockableSql(this.lockTable, sb.toString(), this.dbType);
            ps = conn.prepareStatement(checkLockSQL);
            for (int i = 0; i < lockDOs.size(); ++i) {
                ps.setString(i + 1, lockDOs.get(i).getRowKey());
            }
            rs = ps.executeQuery();
            String currentXID = lockDOs.get(0).getXid();
            while (rs.next()) {
                String dbXID = rs.getString("xid");
                if (!StringUtils.equals(dbXID, currentXID)) {
                    if (LOGGER.isInfoEnabled()) {
                        String dbPk = rs.getString("pk");
                        String dbTableName = rs.getString("table_name");
                        Long dbBranchId = rs.getLong("branch_id");
                        LOGGER.info("Global lock on [{}:{}] is holding by xid {} branchId {}", new Object[]{dbTableName, dbPk, dbXID, dbBranchId});
                    }
                    canLock &= false;
                    break;
                }
                dbExistedRowKeys.add(rs.getString("row_key"));
            }
            if (!canLock) {
                conn.rollback();
                boolean bl = false;
                return bl;
            }
            unrepeatedLockDOs = CollectionUtils.isNotEmpty(dbExistedRowKeys) ? lockDOs.stream().filter(lockDO -> !dbExistedRowKeys.contains(lockDO.getRowKey())).collect(Collectors.toList()) : lockDOs;
            if (CollectionUtils.isEmpty(unrepeatedLockDOs)) {
                conn.rollback();
                boolean bl = true;
                return bl;
            }
            for (LockDO lockDO2 : unrepeatedLockDOs) {
                if (this.doAcquireLock(conn, lockDO2)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Global lock acquire failed, xid {} branchId {} pk {}", new Object[]{lockDO2.getXid(), lockDO2.getBranchId(), lockDO2.getPk()});
                }
                conn.rollback();
                boolean bl = false;
                return bl;
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    if (originalAutoCommit) {
                        conn.setAutoCommit(true);
                    }
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean unLock(LockDO lockDO) {
        return this.unLock(Collections.singletonList(lockDO));
    }

    @Override
    public boolean unLock(List<LockDO> lockDOs) {
        Connection conn = null;
        Statement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lockDOs.size(); ++i) {
                sb.append("?");
                if (i == lockDOs.size() - 1) continue;
                sb.append(", ");
            }
            String batchDeleteSQL = LockStoreSqls.getBatchDeleteLockSql(this.lockTable, sb.toString(), this.dbType);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, lockDOs.get(0).getXid());
            for (int i = 0; i < lockDOs.size(); ++i) {
                ps.setString(i + 2, lockDOs.get(i).getRowKey());
            }
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public boolean isLockable(List<LockDO> lockDOs) {
        Connection conn = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            if (!this.checkLockable(conn, lockDOs)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean doAcquireLock(Connection conn, LockDO lockDO) {
        Statement ps = null;
        try {
            String insertLockSQL = LockStoreSqls.getInsertLockSQL(this.lockTable, this.dbType);
            ps = conn.prepareStatement(insertLockSQL);
            ps.setString(1, lockDO.getXid());
            ps.setLong(2, lockDO.getTransactionId());
            ps.setLong(3, lockDO.getBranchId());
            ps.setString(4, lockDO.getResourceId());
            ps.setString(5, lockDO.getTableName());
            ps.setString(6, lockDO.getPk());
            ps.setString(7, lockDO.getRowKey());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new StoreException(e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean checkLockable(Connection conn, List<LockDO> lockDOs) {
        Statement ps = null;
        ResultSet rs = null;
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lockDOs.size(); ++i) {
                sb.append("?");
                if (i == lockDOs.size() - 1) continue;
                sb.append(", ");
            }
            String checkLockSQL = LockStoreSqls.getCheckLockableSql(this.lockTable, sb.toString(), this.dbType);
            ps = conn.prepareStatement(checkLockSQL);
            for (int i = 0; i < lockDOs.size(); ++i) {
                ps.setString(i + 1, lockDOs.get(i).getRowKey());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String xid = rs.getString("xid");
                if (StringUtils.equals(xid, lockDOs.get(0).getXid())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void setLockTable(String lockTable) {
        this.lockTable = lockTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setLogStoreDataSource(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }
}

