/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationProvider;
import io.seata.config.FileConfiguration;
import java.util.Objects;

public final class ConfigurationFactory {
    private static final String REGISTRY_CONF_PREFIX = "registry";
    private static final String REGISTRY_CONF_SUFFIX = ".conf";
    private static final String ENV_SYSTEM_KEY = "SEATA_ENV";
    public static final String ENV_PROPERTY_KEY = "seataEnv";
    private static final String SYSTEM_PROPERTY_SEATA_CONFIG_NAME = "seata.config.name";
    private static final String ENV_SEATA_CONFIG_NAME = "SEATA_CONFIG_NAME";
    public static final Configuration CURRENT_FILE_INSTANCE;
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";
    private static volatile Configuration instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (instance != null) return instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (instance != null) return instance;
            instance = ConfigurationFactory.buildConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static Configuration buildConfiguration() {
        ConfigType configType = null;
        String configTypeName = null;
        try {
            configTypeName = CURRENT_FILE_INSTANCE.getConfig("config.type");
            configType = ConfigType.getType(configTypeName);
        }
        catch (Exception e) {
            throw new NotSupportYetException("not support register type: " + configTypeName, e);
        }
        if (ConfigType.File == configType) {
            String pathDataId = "config.file.name";
            String name = CURRENT_FILE_INSTANCE.getConfig(pathDataId);
            return new FileConfiguration(name);
        }
        return EnhancedServiceLoader.load(ConfigurationProvider.class, Objects.requireNonNull(configType).name()).provide();
    }

    static {
        String envValue;
        String seataConfigName = System.getProperty(SYSTEM_PROPERTY_SEATA_CONFIG_NAME);
        if (null == seataConfigName) {
            seataConfigName = System.getenv(ENV_SEATA_CONFIG_NAME);
        }
        if (null == seataConfigName) {
            seataConfigName = REGISTRY_CONF_PREFIX;
        }
        if (null == (envValue = System.getProperty(ENV_PROPERTY_KEY))) {
            envValue = System.getenv(ENV_SYSTEM_KEY);
        }
        CURRENT_FILE_INSTANCE = null == envValue ? new FileConfiguration(seataConfigName + REGISTRY_CONF_SUFFIX) : new FileConfiguration(seataConfigName + "-" + envValue + REGISTRY_CONF_SUFFIX);
        instance = null;
    }
}

