/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.BitSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.RegexSerializer;
import de.javakaffee.kryoserializers.URISerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import io.seata.core.serializer.SerializerClassRegistry;
import io.seata.serializer.kryo.KryoInnerSerializer;
import java.lang.reflect.InvocationHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.BitSet;
import java.util.GregorianCalendar;
import java.util.UUID;
import java.util.regex.Pattern;

public class KryoSerializerFactory
implements KryoFactory {
    private static final KryoSerializerFactory FACTORY = new KryoSerializerFactory();
    private KryoPool pool = new KryoPool.Builder((KryoFactory)this).softReferences().build();

    private KryoSerializerFactory() {
    }

    public static KryoSerializerFactory getInstance() {
        return FACTORY;
    }

    public KryoInnerSerializer get() {
        return new KryoInnerSerializer(this.pool.borrow());
    }

    public void returnKryo(KryoInnerSerializer kryoSerializer) {
        if (kryoSerializer == null) {
            throw new IllegalArgumentException("kryoSerializer is null");
        }
        this.pool.release(kryoSerializer.getKryo());
    }

    public Kryo create() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        kryo.register(BigDecimal.class, (Serializer)new DefaultSerializers.BigDecimalSerializer());
        kryo.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        kryo.register(Pattern.class, (Serializer)new RegexSerializer());
        kryo.register(BitSet.class, (Serializer)new BitSetSerializer());
        kryo.register(URI.class, (Serializer)new URISerializer());
        kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        SerializerClassRegistry.getRegisteredClasses().keySet().forEach(arg_0 -> ((Kryo)kryo).register(arg_0));
        return kryo;
    }
}

