/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.routing;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.bus.Event;
import reactor.bus.registry.Registration;
import reactor.bus.routing.Router;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public class TraceableDelegatingRouter
implements Router {
    private final Router delegate;
    private final Logger log;

    public TraceableDelegatingRouter(Router delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate EventRouter cannot be null.");
        this.delegate = delegate;
        this.log = LoggerFactory.getLogger(delegate.getClass());
    }

    @Override
    public <E extends Event<?>> void route(Object key, E event, List<Registration<Object, ? extends Consumer<? extends Event<?>>>> consumers, Consumer<E> completionConsumer, Consumer<Throwable> errorConsumer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("route({}, {}, {}, {}, {})", new Object[]{key, event, consumers, completionConsumer, errorConsumer});
        }
        this.delegate.route(key, event, consumers, completionConsumer, errorConsumer);
    }
}

