/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.registry;

import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.MultiReaderFastList;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.bus.registry.CachableRegistration;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registry;
import reactor.bus.selector.Selector;
import reactor.fn.Consumer;
import reactor.jarjar.jsr166e.ConcurrentHashMapV8;

public class CachingRegistry<K, V>
implements Registry<K, V> {
    private final NewThreadLocalRegsFn newThreadLocalRegsFn = new NewThreadLocalRegsFn();
    private final boolean useCache;
    private final boolean cacheNotFound;
    private final Consumer<K> onNotFound;
    private final MultiReaderFastList<Registration<K, ? extends V>> registrations;
    private final ConcurrentHashMapV8<Long, UnifiedMap<Object, List<Registration<K, ? extends V>>>> threadLocalCache;

    CachingRegistry(boolean useCache, boolean cacheNotFound, Consumer<K> onNotFound) {
        this.useCache = useCache;
        this.cacheNotFound = cacheNotFound;
        this.onNotFound = onNotFound;
        this.registrations = MultiReaderFastList.newList();
        this.threadLocalCache = new ConcurrentHashMapV8();
    }

    @Override
    public Registration<K, V> register(Selector<K> sel, V obj) {
        RemoveRegistration removeFn = new RemoveRegistration();
        final CachableRegistration reg = new CachableRegistration(sel, obj, removeFn);
        removeFn.reg = reg;
        this.registrations.withWriteLockAndDelegate(new Procedure<MutableList<Registration<K, ? extends V>>>(){

            public void value(MutableList<Registration<K, ? extends V>> regs) {
                regs.add((Object)reg);
            }
        });
        if (this.useCache) {
            this.threadLocalCache.clear();
        }
        return reg;
    }

    @Override
    public boolean unregister(final K key) {
        final AtomicBoolean modified = new AtomicBoolean(false);
        this.registrations.withWriteLockAndDelegate(new Procedure<MutableList<Registration<K, ? extends V>>>(){

            public void value(MutableList<Registration<K, ? extends V>> regs) {
                Iterator registrationIterator = regs.iterator();
                while (registrationIterator.hasNext()) {
                    Registration reg = (Registration)registrationIterator.next();
                    if (!reg.getSelector().matches(key)) continue;
                    registrationIterator.remove();
                    modified.compareAndSet(false, true);
                }
                if (CachingRegistry.this.useCache && modified.get()) {
                    CachingRegistry.this.threadLocalCache.clear();
                }
            }
        });
        return modified.get();
    }

    @Override
    public List<Registration<K, ? extends V>> select(K key) {
        UnifiedMap<Object, List<Registration<K, V>>> allRegs = this.threadLocalRegs();
        Object selectedRegs = null;
        if (this.useCache && null != (selectedRegs = (List)allRegs.get(key))) {
            return selectedRegs;
        }
        this.cacheMiss(key);
        selectedRegs = FastList.newList();
        for (Registration<K, V> reg : this) {
            if (!reg.getSelector().matches(key)) continue;
            selectedRegs.add(reg);
        }
        if (this.useCache && (!selectedRegs.isEmpty() || this.cacheNotFound)) {
            allRegs.put(key, selectedRegs);
        }
        if (selectedRegs.isEmpty() && null != this.onNotFound) {
            this.onNotFound.accept(key);
        }
        return selectedRegs;
    }

    @Override
    public void clear() {
        this.registrations.clear();
        this.threadLocalCache.clear();
    }

    @Override
    public Iterator<Registration<K, ? extends V>> iterator() {
        return FastList.newList(this.registrations).iterator();
    }

    protected void cacheMiss(Object key) {
    }

    private UnifiedMap<Object, List<Registration<K, ? extends V>>> threadLocalRegs() {
        Long threadId = Thread.currentThread().getId();
        UnifiedMap<Object, List<Registration<K, ? extends V>>> regs = this.threadLocalCache.get(threadId);
        if (null == regs) {
            regs = this.threadLocalCache.computeIfAbsent(threadId, this.newThreadLocalRegsFn);
        }
        return regs;
    }

    private final class NewThreadLocalRegsFn
    implements ConcurrentHashMapV8.Fun<Long, UnifiedMap<Object, List<Registration<K, ? extends V>>>> {
        private NewThreadLocalRegsFn() {
        }

        @Override
        public UnifiedMap<Object, List<Registration<K, ? extends V>>> apply(Long aLong) {
            return UnifiedMap.newMap();
        }
    }

    private final class RemoveRegistration
    implements Runnable {
        Registration<K, ? extends V> reg;

        private RemoveRegistration() {
        }

        @Override
        public void run() {
            CachingRegistry.this.registrations.withWriteLockAndDelegate(new Procedure<MutableList<Registration<K, ? extends V>>>(){

                public void value(MutableList<Registration<K, ? extends V>> regs) {
                    regs.remove(RemoveRegistration.this.reg);
                    CachingRegistry.this.threadLocalCache.clear();
                }
            });
        }
    }
}

