/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.tcp.InetSocketAddressUtil;
import reactor.netty.tcp.ProxyProvider;
import reactor.netty.tcp.TcpMetricsHandler;
import reactor.util.Logger;
import reactor.util.Loggers;

final class TcpUtils {
    static final Logger log = Loggers.getLogger(TcpUtils.class);
    static final ChannelOperations.OnSetup TCP_OPS = (ch, c, msg) -> new ChannelOperations(ch, c);
    static final String SERVER_METRICS_NAME = "reactor.netty.tcp.server";
    static final String CLIENT_METRICS_NAME = "reactor.netty.tcp.client";

    TcpUtils() {
    }

    static Bootstrap updateProxySupport(Bootstrap b, ProxyProvider proxyOptions) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.proxyHandler", new ProxyProvider.DeferredProxySupport(proxyOptions));
        if (b.config().resolver() == DefaultAddressResolverGroup.INSTANCE) {
            return b.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        return b;
    }

    static Bootstrap removeProxySupport(Bootstrap b) {
        return BootstrapHandlers.removeConfiguration(b, "reactor.left.proxyHandler");
    }

    static ServerBootstrap updateMetricsSupport(ServerBootstrap b, @Nullable String name) {
        return BootstrapHandlers.updateConfiguration(b, "reactor.left.tcpMetricsHandler", (BiConsumer<ConnectionObserver, ? super Channel>)new MetricsSupportConsumer(name == null ? SERVER_METRICS_NAME : name, true));
    }

    static Bootstrap updateMetricsSupport(Bootstrap b, @Nullable String name) {
        return BootstrapHandlers.updateConfiguration(b, "reactor.left.tcpMetricsHandler", new DeferredMetricsSupport(name == null ? CLIENT_METRICS_NAME : name, false));
    }

    static ServerBootstrap removeMetricsSupport(ServerBootstrap b) {
        return BootstrapHandlers.removeConfiguration(b, "reactor.left.tcpMetricsHandler");
    }

    static Bootstrap removeMetricsSupport(Bootstrap b) {
        return BootstrapHandlers.removeConfiguration(b, "reactor.left.tcpMetricsHandler");
    }

    static Bootstrap updateHost(Bootstrap b, String host) {
        return b.remoteAddress(TcpUtils._updateHost(b.config().remoteAddress(), host));
    }

    static ServerBootstrap updateHost(ServerBootstrap b, String host) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updateHost(b.config().localAddress(), host));
    }

    static SocketAddress _updateHost(@Nullable SocketAddress address, String host) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(host, 0);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        return InetSocketAddressUtil.createUnresolved(host, inet.getPort());
    }

    static Bootstrap updatePort(Bootstrap b, int port) {
        return b.remoteAddress(TcpUtils._updatePort(b.config().remoteAddress(), port));
    }

    static ServerBootstrap updatePort(ServerBootstrap b, int port) {
        return (ServerBootstrap)b.localAddress(TcpUtils._updatePort(b.config().localAddress(), port));
    }

    static SocketAddress _updatePort(@Nullable SocketAddress address, int port) {
        if (!(address instanceof InetSocketAddress)) {
            return InetSocketAddressUtil.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), port);
        }
        InetSocketAddress inet = (InetSocketAddress)address;
        InetAddress addr = inet.getAddress();
        String host = addr == null ? inet.getHostName() : addr.getHostAddress();
        return InetSocketAddressUtil.createUnresolved(host, port);
    }

    static SocketAddressSupplier lazyAddress(Supplier<? extends SocketAddress> supplier) {
        return new SocketAddressSupplier(supplier);
    }

    static final class MetricsSupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final String name;
        final String remoteAddress;
        final boolean onServer;

        MetricsSupportConsumer(String name, boolean onServer) {
            this(name, null, onServer);
        }

        MetricsSupportConsumer(String name, @Nullable String remoteAddress, boolean onServer) {
            this.name = name;
            this.remoteAddress = remoteAddress;
            this.onServer = onServer;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            String address = this.remoteAddress;
            if (address == null) {
                SocketAddress socketAddress = channel.remoteAddress();
                address = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : socketAddress.toString();
            }
            channel.pipeline().addFirst("reactor.left.tcpMetricsHandler", (ChannelHandler)new TcpMetricsHandler(this.name, address, this.onServer));
        }
    }

    static final class DeferredMetricsSupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final String name;
        final boolean onServer;

        DeferredMetricsSupport(String name, boolean onServer) {
            this.name = name;
            this.onServer = onServer;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            SocketAddress socketAddress = bootstrap.config().remoteAddress();
            String address = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : socketAddress.toString();
            return new MetricsSupportConsumer(this.name, address, this.onServer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredMetricsSupport that = (DeferredMetricsSupport)o;
            return this.onServer == that.onServer && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.onServer);
        }
    }

    static final class SocketAddressSupplier
    extends SocketAddress
    implements Supplier<SocketAddress> {
        final Supplier<? extends SocketAddress> supplier;

        SocketAddressSupplier(Supplier<? extends SocketAddress> supplier) {
            this.supplier = Objects.requireNonNull(supplier, "Lazy address supplier must not be null");
        }

        @Override
        public SocketAddress get() {
            return this.supplier.get();
        }
    }
}

