/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

final class HttpClientMetricsHandler
extends ChannelDuplexHandler {
    HttpRequest request;
    HttpResponse response;
    long dataReceived;
    long dataSent;
    Timer.Sample dataReceivedTimeSample;
    Timer.Sample dataSentTimeSample;
    final MeterRegistry registry;
    final String name;
    final Timer.Builder dataReceivedTimeBuilder;
    final Timer.Builder dataSentTimeBuilder;
    final Timer.Builder responseTimeBuilder;

    public HttpClientMetricsHandler(MeterRegistry registry, String name) {
        this.registry = registry;
        this.name = name;
        this.dataReceivedTimeBuilder = Timer.builder((String)(name + ".data.received.time")).description("Time that is spent in consuming incoming data");
        this.dataSentTimeBuilder = Timer.builder((String)(name + ".data.sent.time")).description("Time that is spent in sending outgoing data");
        this.responseTimeBuilder = Timer.builder((String)(name + ".response.time")).description("Total time for the request/response");
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            this.dataSentTimeSample = Timer.start((MeterRegistry)this.registry);
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                SocketAddress socketAddress = ctx.channel().remoteAddress();
                String address = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : socketAddress.toString();
                Timer dataSentTime = this.dataSentTimeBuilder.tags(new String[]{"remote.address", address, "uri", this.request.uri(), "method", this.request.method().name()}).register(this.registry);
                this.dataSentTimeSample.stop(dataSentTime);
                DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tags(new String[]{"remote.address", address, "uri", this.request.uri()}).register(this.registry).record((double)this.dataSent);
            });
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            this.dataReceivedTimeSample = Timer.start((MeterRegistry)this.registry);
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            String address = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : socketAddress.toString();
            this.dataReceivedTimeSample.stop(this.dataReceivedTimeBuilder.tags(new String[]{"remote.address", address, "uri", this.request.uri(), "method", this.request.method().name(), "status", this.response.status().codeAsText().toString()}).register(this.registry));
            Timer responseTime = this.responseTimeBuilder.tags(new String[]{"remote.address", address, "uri", this.request.uri(), "method", this.request.method().name(), "status", this.response.status().codeAsText().toString()}).register(this.registry);
            this.dataSentTimeSample.stop(responseTime);
            DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tags(new String[]{"remote.address", address, "uri", this.request.uri()}).register(this.registry).record((double)this.dataReceived);
            this.reset();
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        String address = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : socketAddress.toString();
        Counter.builder((String)(this.name + ".errors")).description("Number of the errors that are occurred").tags(new String[]{"remote.address", address, "uri", this.request.uri()}).register(this.registry).increment();
        super.exceptionCaught(ctx, cause);
    }

    private void reset() {
        this.request = null;
        this.response = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTimeSample = null;
        this.dataSentTimeSample = null;
    }
}

