/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoop;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.DisposableChannel;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

public final class ReactorNetty {
    static final boolean LOG_CHANNEL_INFO = Boolean.parseBoolean(System.getProperty("reactor.netty.logChannelInfo", "true"));
    public static final String IO_WORKER_COUNT = "reactor.netty.ioWorkerCount";
    public static final String IO_SELECT_COUNT = "reactor.netty.ioSelectCount";
    public static final String UDP_IO_THREAD_COUNT = "reactor.netty.udp.ioThreadCount";
    public static final String NATIVE = "reactor.netty.native";
    public static final String POOL_MAX_CONNECTIONS = "reactor.netty.pool.maxConnections";
    public static final String POOL_ACQUIRE_TIMEOUT = "reactor.netty.pool.acquireTimeout";
    public static final String SSL_HANDSHAKE_TIMEOUT = "reactor.netty.tcp.sslHandshakeTimeout";
    public static final String SSL_CLIENT_DEBUG = "reactor.netty.tcp.ssl.client.debug";
    public static final String SSL_SERVER_DEBUG = "reactor.netty.tcp.ssl.server.debug";
    public static final String ACCESS_LOG_ENABLED = "reactor.netty.http.server.accessLogEnabled";
    static final ConnectionObserver.State CONNECTED = new ConnectionObserver.State(){

        public String toString() {
            return "[connected]";
        }
    };
    static final ConnectionObserver.State ACQUIRED = new ConnectionObserver.State(){

        public String toString() {
            return "[acquired]";
        }
    };
    static final ConnectionObserver.State CONFIGURED = new ConnectionObserver.State(){

        public String toString() {
            return "[configured]";
        }
    };
    static final ConnectionObserver.State RELEASED = new ConnectionObserver.State(){

        public String toString() {
            return "[released]";
        }
    };
    static final ConnectionObserver.State DISCONNECTING = new ConnectionObserver.State(){

        public String toString() {
            return "[disconnecting]";
        }
    };
    static final ConnectionObserver NOOP_LISTENER = (connection, newState) -> {};
    static final Logger log = Loggers.getLogger(ReactorNetty.class);
    static final AttributeKey<Boolean> PERSISTENT_CHANNEL = AttributeKey.newInstance((String)"$PERSISTENT_CHANNEL");
    static final AttributeKey<Connection> CONNECTION = AttributeKey.newInstance((String)"$CONNECTION");
    static final Consumer<? super FileChannel> fileCloser = fc -> {
        block2: {
            try {
                fc.close();
            }
            catch (Throwable e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("", e);
            }
        }
    };
    static final Predicate<ByteBuf> PREDICATE_BB_FLUSH = b -> false;
    static final Predicate<Object> PREDICATE_FLUSH = o -> false;
    static final ByteBuf BOUNDARY = Unpooled.EMPTY_BUFFER;
    public static final Predicate<ByteBuf> PREDICATE_GROUP_FLUSH = b -> b == BOUNDARY;

    public static void safeRelease(Object msg) {
        ReferenceCounted referenceCounted;
        if (msg instanceof ReferenceCounted && (referenceCounted = (ReferenceCounted)msg).refCnt() > 0) {
            referenceCounted.release();
        }
    }

    public static String format(Channel channel, String msg) {
        if (LOG_CHANNEL_INFO) {
            String channelStr = channel.toString();
            return new StringBuilder(channelStr.length() + 1 + msg.length()).append(channel).append(' ').append(msg).toString();
        }
        return msg;
    }

    public static RuntimeException wrapException(Throwable throwable) {
        return new InternalNettyException(Objects.requireNonNull(throwable));
    }

    static void addChunkedWriter(Connection c) {
        if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
            c.addHandlerLast("reactor.left.chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
    }

    static void addHandlerBeforeReactorEndHandlers(Connection context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Handler [{}] already exists in the pipeline, decoder has been skipped"), new Object[]{name});
            }
            return;
        }
        String before = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("reactor.right.")) continue;
            before = s;
            break;
        }
        if (before == null) {
            channel.pipeline().addLast(name, handler);
        } else {
            channel.pipeline().addBefore("reactor.right.reactiveBridge", name, handler);
        }
        ReactorNetty.registerForClose(context.isPersistent(), name, context);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Added decoder [{}] at the end of the user pipeline, full pipeline: {}"), new Object[]{name, channel.pipeline().names()});
        }
    }

    static void addHandlerAfterReactorCodecs(Connection context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Handler [{}] already exists in the pipeline, encoder has been skipped"), new Object[]{name});
            }
            return;
        }
        String after = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("reactor.left.")) continue;
            after = s;
        }
        if (after == null) {
            channel.pipeline().addFirst(name, handler);
        } else {
            channel.pipeline().addAfter(after, name, handler);
        }
        ReactorNetty.registerForClose(context.isPersistent(), name, context);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Added encoder [{}] at the beginning of the user pipeline, full pipeline: {}"), new Object[]{name, channel.pipeline().names()});
        }
    }

    static boolean mustChunkFileTransfer(Connection c, Path file) {
        if (c.channel().parent() != null && c.channel().parent().pipeline().get(Http2ConnectionHandler.class) != null) {
            return true;
        }
        ChannelPipeline p = c.channel().pipeline();
        return p.get(SslHandler.class) != null || p.get("reactor.left.compressionHandler") != null || !(c.channel().eventLoop() instanceof NioEventLoop) && !"file".equals(file.toUri().getScheme());
    }

    static void registerForClose(boolean shouldCleanupOnClose, String name, Connection context) {
        if (!shouldCleanupOnClose) {
            return;
        }
        context.onTerminate().subscribe(null, null, () -> context.removeHandler(name));
    }

    static void removeHandler(Channel channel, String name) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().remove(name);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Removed handler: {}, pipeline: {}"), new Object[]{name, channel.pipeline()});
            }
        } else if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Non Removed handler: {}, context: {}, pipeline: {}"), new Object[]{name, channel.pipeline().context(name), channel.pipeline()});
        }
    }

    static void replaceHandler(Channel channel, String name, ChannelHandler handler) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().replace(name, name, handler);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Replaced handler: {}, pipeline: {}"), new Object[]{name, channel.pipeline()});
            }
        } else if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(channel, "Non Replaced handler: {}, context: {}, pipeline: {}"), new Object[]{name, channel.pipeline().context(name), channel.pipeline()});
        }
    }

    static ConnectionObserver compositeConnectionObserver(ConnectionObserver observer, ConnectionObserver other) {
        int pos;
        ConnectionObserver[] otherObservers;
        ConnectionObserver[] thizObservers;
        if (observer == ConnectionObserver.emptyListener()) {
            return other;
        }
        if (other == ConnectionObserver.emptyListener()) {
            return observer;
        }
        int length = 2;
        if (observer instanceof CompositeConnectionObserver) {
            thizObservers = ((CompositeConnectionObserver)observer).observers;
            length += thizObservers.length - 1;
        } else {
            thizObservers = null;
        }
        if (other instanceof CompositeConnectionObserver) {
            otherObservers = ((CompositeConnectionObserver)other).observers;
            length += otherObservers.length - 1;
        } else {
            otherObservers = null;
        }
        ConnectionObserver[] newObservers = new ConnectionObserver[length];
        if (thizObservers != null) {
            pos = thizObservers.length;
            System.arraycopy(thizObservers, 0, newObservers, 0, pos);
        } else {
            pos = 1;
            newObservers[0] = observer;
        }
        if (otherObservers != null) {
            System.arraycopy(otherObservers, 0, newObservers, pos, otherObservers.length);
        } else {
            newObservers[pos] = other;
        }
        return new CompositeConnectionObserver(newObservers);
    }

    static <T, V> CorePublisher<V> publisherOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> mapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, mapper));
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).map(mapper);
        }
        return Flux.from(publisher).map(mapper);
    }

    ReactorNetty() {
    }

    static NettyInbound unavailableInbound(final Connection c) {
        return new NettyInbound(){

            @Override
            public ByteBufFlux receive() {
                return ByteBufFlux.fromInbound(Mono.error((Throwable)new IllegalStateException("Receiver Unavailable. The Connection")));
            }

            @Override
            public Flux<?> receiveObject() {
                return Flux.error((Throwable)new IllegalStateException("Receiver Unavailable"));
            }

            @Override
            public NettyInbound withConnection(Consumer<? super Connection> withConnection) {
                withConnection.accept(c);
                return this;
            }
        };
    }

    static NettyOutbound unavailableOutbound(final Connection c) {
        return new NettyOutbound(){

            @Override
            public ByteBufAllocator alloc() {
                return c.channel().alloc();
            }

            @Override
            public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
                return this;
            }

            @Override
            public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
                return this;
            }

            @Override
            public NettyOutbound sendObject(Object message) {
                return this;
            }

            @Override
            public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
                return this;
            }

            @Override
            public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
                withConnection.accept(c);
                return this;
            }

            @Override
            public Mono<Void> then() {
                return Mono.error((Throwable)new IllegalStateException("Sender Unavailable"));
            }
        };
    }

    static final class InternalNettyException
    extends RuntimeException {
        InternalNettyException(Throwable cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class SimpleConnection
    implements Connection {
        final Channel channel;

        SimpleConnection(Channel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        public String toString() {
            return "SimpleConnection{channel=" + this.channel + '}';
        }
    }

    static final class ChannelDisposer
    extends BaseSubscriber<Void> {
        final DisposableChannel channelDisposable;

        ChannelDisposer(DisposableChannel channelDisposable) {
            this.channelDisposable = channelDisposable;
        }

        protected void hookOnSubscribe(Subscription subscription) {
            this.request(Long.MAX_VALUE);
            this.channelDisposable.onDispose((Disposable)this);
        }

        protected void hookFinally(SignalType type) {
            if (type != SignalType.CANCEL) {
                this.channelDisposable.dispose();
            }
        }
    }

    @ChannelHandler.Sharable
    static final class ExtractorHandler
    extends ChannelInboundHandlerAdapter {
        final BiConsumer<? super ChannelHandlerContext, Object> extractor;

        ExtractorHandler(BiConsumer<? super ChannelHandlerContext, Object> extractor) {
            this.extractor = Objects.requireNonNull(extractor, "extractor");
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.extractor.accept((ChannelHandlerContext)ctx, msg);
        }
    }

    static final class InboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onReadIdle;

        InboundIdleStateHandler(long idleTimeout, Runnable onReadIdle) {
            super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
            this.onReadIdle = onReadIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.READER_IDLE) {
                this.onReadIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onWriteIdle;

        OutboundIdleStateHandler(long idleTimeout, Runnable onWriteIdle) {
            super(0L, idleTimeout, 0L, TimeUnit.MILLISECONDS);
            this.onWriteIdle = onWriteIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                this.onWriteIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundThen
    implements NettyOutbound {
        final NettyOutbound source;
        final Mono<Void> thenMono;
        static final Runnable EMPTY_CLEANUP = () -> {};

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher) {
            this(source, thenPublisher, EMPTY_CLEANUP);
        }

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher, Runnable onCleanup) {
            this.source = source;
            Objects.requireNonNull(onCleanup, "onCleanup");
            Mono<Void> parentMono = source.then();
            this.thenMono = parentMono == Mono.empty() ? (onCleanup == EMPTY_CLEANUP ? Mono.from(thenPublisher) : Mono.from(thenPublisher).doOnCancel(onCleanup).doOnError(t -> onCleanup.run())) : (onCleanup == EMPTY_CLEANUP ? parentMono.thenEmpty(thenPublisher) : parentMono.thenEmpty(thenPublisher).doOnCancel(onCleanup).doOnError(t -> onCleanup.run()));
        }

        @Override
        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.then(this.source.sendUsing(sourceInput, mappedInput, sourceCleanup));
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.source.alloc();
        }

        @Override
        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.source.withConnection(withConnection);
        }

        @Override
        public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
            return this.then(this.source.send(dataStream, predicate));
        }

        @Override
        public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
            return this.then(this.source.sendObject(dataStream, predicate));
        }

        @Override
        public NettyOutbound sendObject(Object message) {
            return this.then(this.source.sendObject(message), () -> ReactorNetty.safeRelease(message));
        }

        @Override
        public Mono<Void> then() {
            return this.thenMono;
        }
    }

    static final class CompositeConnectionObserver
    implements ConnectionObserver {
        final ConnectionObserver[] observers;

        CompositeConnectionObserver(ConnectionObserver[] observers) {
            this.observers = observers;
        }

        @Override
        public Context currentContext() {
            return this.observers[this.observers.length - 1].currentContext();
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            for (ConnectionObserver observer : this.observers) {
                observer.onUncaughtException(connection, error);
            }
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            for (ConnectionObserver observer : this.observers) {
                observer.onStateChange(connection, newState);
            }
        }
    }

    static final class ScalarMap<T, V>
    implements Callable<V> {
        final Callable<T> source;
        final Function<? super T, ? extends V> mapper;

        ScalarMap(Publisher<T> source, Function<? super T, ? extends V> mapper) {
            this.source = (Callable)source;
            this.mapper = mapper;
        }

        @Override
        public V call() throws Exception {
            T called = this.source.call();
            if (called == null) {
                return null;
            }
            return this.mapper.apply(called);
        }
    }
}

