/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AttributesProcessor {
    static final AttributesProcessor NOOP = AttributesProcessor.simple(incoming -> incoming);

    private AttributesProcessor() {
    }

    public abstract Attributes process(Attributes var1, Context var2);

    public abstract boolean usesContext();

    public AttributesProcessor then(AttributesProcessor other) {
        if (other == NOOP) {
            return this;
        }
        if (this == NOOP) {
            return other;
        }
        if (other instanceof JoinedAttributesProcessor) {
            return ((JoinedAttributesProcessor)other).prepend(this);
        }
        return new JoinedAttributesProcessor(Arrays.asList(this, other));
    }

    public static AttributesProcessor noop() {
        return NOOP;
    }

    public static AttributesProcessor filterByKeyName(Predicate<String> nameFilter) {
        return AttributesProcessor.simple(incoming -> {
            AttributesBuilder result = Attributes.builder();
            incoming.forEach((k, v) -> {
                if (nameFilter.test(k.getKey())) {
                    result.put(k, v);
                }
            });
            return result.build();
        });
    }

    public static AttributesProcessor appendBaggageByKeyName(Predicate<String> nameFilter) {
        return AttributesProcessor.onBaggage((incoming, baggage) -> {
            AttributesBuilder result = Attributes.builder();
            baggage.forEach((k, v) -> {
                if (nameFilter.test((String)k)) {
                    result.put(k, v.getValue());
                }
            });
            result.putAll(incoming);
            return result.build();
        });
    }

    public static AttributesProcessor append(Attributes attributes) {
        return AttributesProcessor.simple(incoming -> attributes.toBuilder().putAll(incoming).build());
    }

    static AttributesProcessor simple(final UnaryOperator<Attributes> processor) {
        return new AttributesProcessor(){

            @Override
            public Attributes process(Attributes incoming, Context context) {
                return (Attributes)processor.apply(incoming);
            }

            @Override
            public boolean usesContext() {
                return false;
            }
        };
    }

    static AttributesProcessor onBaggage(final BiFunction<Attributes, Baggage, Attributes> processor) {
        return new AttributesProcessor(){

            @Override
            public Attributes process(Attributes incoming, Context context) {
                return (Attributes)processor.apply(incoming, Baggage.fromContext((Context)context));
            }

            @Override
            public boolean usesContext() {
                return true;
            }
        };
    }

    @Immutable
    static final class JoinedAttributesProcessor
    extends AttributesProcessor {
        private final Collection<AttributesProcessor> processors;
        private final boolean usesContextCache;

        JoinedAttributesProcessor(Collection<AttributesProcessor> processors) {
            this.processors = processors;
            this.usesContextCache = processors.stream().map(AttributesProcessor::usesContext).reduce(false, (l, r) -> l != false || r != false);
        }

        @Override
        public Attributes process(Attributes incoming, Context context) {
            Attributes result = incoming;
            for (AttributesProcessor processor : this.processors) {
                result = processor.process(result, context);
            }
            return result;
        }

        @Override
        public boolean usesContext() {
            return this.usesContextCache;
        }

        @Override
        public AttributesProcessor then(AttributesProcessor other) {
            ArrayList<AttributesProcessor> newList = new ArrayList<AttributesProcessor>(this.processors);
            if (other instanceof JoinedAttributesProcessor) {
                newList.addAll(((JoinedAttributesProcessor)other).processors);
            } else {
                newList.add(other);
            }
            return new JoinedAttributesProcessor(newList);
        }

        AttributesProcessor prepend(AttributesProcessor other) {
            ArrayList<AttributesProcessor> newList = new ArrayList<AttributesProcessor>(this.processors.size() + 1);
            newList.add(other);
            newList.addAll(this.processors);
            return new JoinedAttributesProcessor(newList);
        }
    }
}

