/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public final class AsynchronousMetricStorage
implements MetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final ReentrantLock collectLock = new ReentrantLock();
    private final InstrumentProcessor<?> instrumentProcessor;
    private final Runnable metricUpdater;

    public static <T> AsynchronousMetricStorage doubleAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().config(instrument).create(resource, instrumentationLibraryInfo, instrument, metricDescriptor);
        final InstrumentProcessor instrumentProcessor = new InstrumentProcessor(aggregator, startEpochNanos);
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableDoubleMeasurement result = new ObservableDoubleMeasurement(){

            public void observe(double value, Attributes attributes) {
                instrumentProcessor.batch(attributesProcessor.process(attributes, Context.current()), aggregator.accumulateDouble(value));
            }

            public void observe(double value) {
                this.observe(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, instrumentProcessor, () -> metricUpdater.accept(result));
    }

    public static <T> AsynchronousMetricStorage longAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos, Consumer<ObservableLongMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().config(instrument).create(resource, instrumentationLibraryInfo, instrument, metricDescriptor);
        final InstrumentProcessor instrumentProcessor = new InstrumentProcessor(aggregator, startEpochNanos);
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableLongMeasurement result = new ObservableLongMeasurement(){

            public void observe(long value, Attributes attributes) {
                instrumentProcessor.batch(attributesProcessor.process(attributes, Context.current()), aggregator.accumulateLong(value));
            }

            public void observe(long value) {
                this.observe(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, instrumentProcessor, () -> metricUpdater.accept(result));
    }

    private AsynchronousMetricStorage(MetricDescriptor metricDescriptor, InstrumentProcessor<?> instrumentProcessor, Runnable metricUpdater) {
        this.metricDescriptor = metricDescriptor;
        this.instrumentProcessor = instrumentProcessor;
        this.metricUpdater = metricUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricData collectAndReset(long startEpochNanos, long epochNanos) {
        this.collectLock.lock();
        try {
            this.metricUpdater.run();
            MetricData metricData = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

