/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.install;

import io.openliberty.tools.ant.RegexRepository;
import io.openliberty.tools.ant.install.InstallLibertyTask;
import io.openliberty.tools.ant.install.InstallUtils;
import io.openliberty.tools.ant.install.Installer;
import io.openliberty.tools.ant.install.LibertyInfo;
import io.openliberty.tools.ant.install.LibertyYaml;
import io.openliberty.tools.ant.install.Version;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class WasDevInstaller
implements Installer {
    private String licenseCode;
    private String version;
    private String type;

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void install(InstallLibertyTask task) throws Exception {
        Version baseVersion;
        task.log("Installing from Wasdev repository...");
        String url = "https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/downloads/wlp/index.yml";
        if (this.type == null) {
            this.type = "webProfile7";
        }
        File cacheDir = new File(task.getCacheDir());
        InstallUtils.createDirectory(cacheDir);
        URL ymlURL = new URL(url);
        File ymlFile = new File(cacheDir, InstallUtils.getFile(ymlURL));
        task.downloadFile(ymlURL, ymlFile);
        List<LibertyInfo> versions = LibertyYaml.parse(ymlFile);
        if (this.version == null) {
            Iterator<LibertyInfo> iterator = versions.iterator();
            while (iterator.hasNext()) {
                LibertyInfo info = iterator.next();
                if (info.getVersion().getMajor() <= 2000) continue;
                iterator.remove();
            }
            baseVersion = Version.parseVersion("+", true);
        } else {
            baseVersion = Version.parseVersion(this.version, true);
        }
        LibertyInfo selectedVersion = InstallUtils.selectVersion(baseVersion, versions);
        File versionCacheDir = new File(task.getCacheDir(), selectedVersion.getVersion().toString());
        InstallUtils.createDirectory(versionCacheDir);
        String uri = this.getRuntimeURI(selectedVersion);
        task.setRuntimeUrl(uri);
        if (uri.endsWith(".jar")) {
            task.checkLicenseSet();
            URL licenseURL = new URL(selectedVersion.getLicenseUri());
            File licenseFile = new File(versionCacheDir, InstallUtils.getFile(licenseURL));
            task.downloadFile(licenseURL, licenseFile, true);
            task.checkLicense(InstallUtils.getLicenseCode(licenseFile, RegexRepository.getRegex(WasDevInstaller.class.getName())));
            URL libertyURL = new URL(uri);
            File libertyFile = new File(versionCacheDir, InstallUtils.getFile(libertyURL));
            task.downloadFile(libertyURL, libertyFile, true);
            task.installLiberty(libertyFile);
        } else if (uri.endsWith(".zip")) {
            URL libertyURL = new URL(uri);
            File libertyFile = new File(versionCacheDir, InstallUtils.getFile(libertyURL));
            task.downloadFile(libertyURL, libertyFile, true);
            task.unzipLiberty(libertyFile);
        } else {
            throw new BuildException("Invalid runtime extension.");
        }
    }

    private String getRuntimeURI(LibertyInfo selected) {
        String value = selected.getProperty(this.type);
        if (value == null) {
            throw new BuildException("Archive type " + this.type + " is not available for Liberty version " + selected.getVersion());
        }
        return value;
    }
}

