/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.jackson.databind;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.processor.jackson.ValidatingAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsonSerializeMapper
extends ValidatingAnnotationMapper {
    @Override
    protected List<AnnotationValue<?>> mapValid(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationClassValue acv = annotation.annotationClassValue("as").orElse(null);
        ArrayList annotations = new ArrayList();
        if (acv != null) {
            annotations.add(AnnotationValue.builder(SerdeConfig.class).member("serAs", new AnnotationClassValue[]{acv}).build());
        }
        return annotations;
    }

    @Override
    protected Set<String> getSupportedMemberNames() {
        return Collections.singleton("as");
    }

    public String getName() {
        return "com.fasterxml.jackson.databind.annotation.JsonSerialize";
    }
}

