/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.uri;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.web.router.uri.PercentEncoder;

public final class UriUtil {
    private UriUtil() {
    }

    public static String toValidPath(String path) {
        int cp;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); i += Character.charCount(cp)) {
            cp = path.codePointAt(i);
            if (cp == 37) {
                boolean validEscape;
                if (i + 2 >= path.length()) {
                    validEscape = false;
                } else {
                    char c1 = path.charAt(i + 1);
                    char c2 = path.charAt(i + 2);
                    boolean bl = validEscape = UriUtil.isAsciiHexDigit(c1) && UriUtil.isAsciiHexDigit(c2);
                }
                if (validEscape) {
                    sb.appendCodePoint(cp);
                    continue;
                }
                PercentEncoder.appendEncodedByte(sb, (byte)37);
                continue;
            }
            if (cp == 47 && sb.length() == 1 && sb.charAt(0) == '/') continue;
            PercentEncoder.RFC3986_QUERY_CHAR.encodeUtf8(sb, cp);
        }
        return sb.toString();
    }

    public static boolean isValidPath(@NonNull String requestTarget) {
        if (requestTarget.isEmpty() || requestTarget.charAt(0) != '/') {
            return false;
        }
        for (int i = 0; i < requestTarget.length(); ++i) {
            char c = requestTarget.charAt(i);
            if (c == '%' || c > '\u007f' || !PercentEncoder.RFC3986_QUERY_CHAR.keep((byte)c)) {
                return false;
            }
            if (c != '/' || i >= requestTarget.length() - 1) continue;
            char next = requestTarget.charAt(i + 1);
            if (next == '/') {
                return false;
            }
            if (next != '.') continue;
            if (i >= requestTarget.length() - 2) {
                return false;
            }
            char nextNext = requestTarget.charAt(i + 2);
            if (nextNext != '.' && nextNext != '/' && nextNext != '?' && nextNext != '#') continue;
            return false;
        }
        return true;
    }

    public static boolean isRelative(@NonNull String requestTarget) {
        boolean start = true;
        for (int i = 0; i < requestTarget.length(); ++i) {
            char c = requestTarget.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r') continue;
            if (UriUtil.isAsciiLowerAlpha(c) || UriUtil.isAsciiUpperAlpha(c)) {
                start = false;
                continue;
            }
            if (!start) {
                if (c == ':') {
                    return false;
                }
                if (UriUtil.isAsciiDigit(c) || c == '+' || c == '-' || c == '.') continue;
                if (!UriUtil.isC0OrSpace(c)) break;
                break;
            }
            if (!UriUtil.isC0OrSpace(c)) break;
        }
        return true;
    }

    private static boolean isC0(int c) {
        return c <= 31;
    }

    private static boolean isC0OrSpace(char c) {
        return UriUtil.isC0(c) || c == ' ';
    }

    private static boolean isAsciiDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isAsciiUpperHexDigit(int c) {
        return UriUtil.isAsciiDigit(c) || c >= 65 && c <= 70;
    }

    private static boolean isAsciiLowerHexDigit(int c) {
        return UriUtil.isAsciiDigit(c) || c >= 97 && c <= 102;
    }

    private static boolean isAsciiHexDigit(int c) {
        return UriUtil.isAsciiLowerHexDigit(c) || UriUtil.isAsciiUpperHexDigit(c);
    }

    private static boolean isAsciiUpperAlpha(int c) {
        return c >= 65 && c <= 90;
    }

    private static boolean isAsciiLowerAlpha(int c) {
        return c >= 97 && c <= 122;
    }
}

