/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import java.util.Optional;

public interface PropertyPlaceholderResolver {
    public Optional<String> resolvePlaceholders(String var1);

    @NonNull
    default public String getPrefix() {
        return "${";
    }

    @NonNull
    default public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        return this.resolvePlaceholders(str).orElseThrow(() -> new ConfigurationException("Unable to resolve placeholders for property: " + str));
    }

    @NonNull
    default public Object resolveRequiredPlaceholdersObject(String str) throws ConfigurationException {
        return this.resolveRequiredPlaceholders(str);
    }

    @NonNull
    default public <T> T resolveRequiredPlaceholder(String str, Class<T> type) throws ConfigurationException {
        throw new ConfigurationException("Unsupported operation");
    }

    default public <T> Optional<T> resolveOptionalPlaceholder(String str, Class<T> type) throws ConfigurationException {
        try {
            return Optional.of(this.resolveRequiredPlaceholder(str, type));
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }
}

