/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.BeanResolutionTracer;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DisabledBean;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyEntry;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.Named;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.AnsiColour;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ConsoleBeanResolutionTracer
implements BeanResolutionTracer {
    private static final String RIGHT_ARROW = AnsiColour.isSupported() ? " \u27a1\ufe0f  " : " -> ";
    private static final String RIGHT_ARROW_LOOP = AnsiColour.isSupported() ? " \u21aa\ufe0f  " : "\\---> ";
    private static final CharSequence START_TIME = "BeanResolutionTrace-start";
    private static final Set<String> INTERNAL_PACKAGES = Set.of("io.micronaut.context", "io.micronaut.aop", "io.micronaut.core.util", "org.codehaus.groovy.vmplugin", "java.util");

    ConsoleBeanResolutionTracer() {
    }

    @Override
    public void traceInitialConfiguration(Environment environment, Collection<BeanDefinitionReference<?>> beanReferences, Collection<DisabledBean<?>> disabledBeans) {
        Collection<PropertySource> propertySources = environment.getPropertySources();
        Set<String> activeNames = environment.getActiveNames();
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            writer.newLine();
            writer.write("Configuration Profile");
            writer.newLine();
            writer.write("---------------------");
            writer.newLine();
            writer.write(AnsiColour.brightBlue((String)"Active Environment Names: ") + String.valueOf(activeNames));
            writer.newLine();
            writer.newLine();
            writer.write(AnsiColour.brightBlue((String)"Available Property Sources (Priority Order Highest to Lowest): "));
            writer.newLine();
            propertySources.stream().sorted(OrderUtil.REVERSE_ORDERED_COMPARATOR).forEach(propertySource -> {
                try {
                    writer.write(" \u271a ");
                    writer.write(AnsiColour.formatObject((Object)propertySource));
                    writer.write(" (");
                    writer.write(propertySource.getOrigin().location() + ")");
                    writer.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            writer.newLine();
            writer.write(AnsiColour.brightBlue((String)"Configurable Beans: "));
            writer.newLine();
            List<BeanDefinitionReference> configRefs = beanReferences.stream().filter(ref -> ref.hasStereotype(ConfigurationReader.class) && ref.stringValue(ConfigurationReader.class, "prefix").isPresent()).sorted((b1, b2) -> {
                String p1 = (String)b1.stringValue(ConfigurationReader.class, "prefix").get();
                String p2 = (String)b2.stringValue(ConfigurationReader.class, "prefix").get();
                return p1.compareTo(p2);
            }).toList();
            configRefs.forEach(ref -> {
                String prefix = ref.stringValue(ConfigurationReader.class, "prefix").orElse(null);
                if (prefix != null) {
                    Argument argument = ref.asArgument();
                    try {
                        writer.write(" \u271a ");
                        writer.write(AnsiColour.formatObject((Object)prefix));
                        writer.write(RIGHT_ARROW);
                        writer.write(TypeInformation.TypeFormat.getTypeString((TypeInformation.TypeFormat)TypeInformation.TypeFormat.ANSI_SHORTENED, (Class)argument.getType(), (Map)argument.getTypeVariables()));
                        writer.newLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            writer.newLine();
            writer.write(AnsiColour.brightBlue((String)"Applicable Configuration Present: "));
            writer.newLine();
            configRefs.stream().flatMap(ref -> ref.stringValue(ConfigurationReader.class, "prefix").stream()).flatMap(prefix -> {
                if (prefix.endsWith(".*")) {
                    String eachProperty = prefix.substring(0, prefix.length() - 2);
                    return environment.getPropertyEntries(eachProperty).stream().flatMap(entry -> {
                        String path = eachProperty + "." + entry;
                        return environment.getPropertyEntries(path).stream().map(p -> path + "." + p);
                    });
                }
                return environment.getPropertyEntries((String)prefix).stream().map(entry -> prefix + "." + entry);
            }).sorted().distinct().forEach(entry -> {
                try {
                    writer.write(" \u271a ");
                    writer.write(AnsiColour.formatObject((Object)entry));
                    PropertyEntry pe = environment.getPropertyEntry((String)entry).orElse(null);
                    if (pe != null) {
                        String text = " Origin(" + AnsiColour.formatObject((Object)pe.raw()) + " from " + AnsiColour.brightYellow((String)pe.origin().location()) + ")";
                        writer.write(text);
                    }
                    writer.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            writer.write("---------------------");
            writer.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeOutput(sw.toString());
    }

    protected abstract void writeOutput(@NonNull String var1);

    @Override
    public void traceBeanCreation(BeanResolutionContext resolutionContext, BeanDefinition<?> beanDefinition, Argument<?> beanType) {
        resolutionContext.setAttribute(START_TIME, System.currentTimeMillis());
        List createdAt = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.dropWhile(f -> !(!INTERNAL_PACKAGES.stream().anyMatch(p -> f.getClassName().startsWith((String)p)) && !f.getDeclaringClass().isSynthetic() || f.getClassName().equals(DefaultBeanContext.class.getName()) && f.getMethodName().equals("start"))).limit(3L).collect(Collectors.toList()));
        String beanName = ConsoleBeanResolutionTracer.getBeanName(beanType, beanDefinition);
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            writer.newLine();
            String beanDescription = beanDefinition.getBeanDescription(TypeInformation.TypeFormat.ANSI_SHORTENED);
            writer.write(beanName + RIGHT_ARROW + beanDescription + " at location:");
            writer.newLine();
            for (StackWalker.StackFrame stackFrame : createdAt) {
                StackTraceElement traceElement = stackFrame.toStackTraceElement();
                StackTraceElement shortened = new StackTraceElement(NameUtils.getShortenedName((String)traceElement.getClassName()), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber());
                writer.write(shortened.toString());
                writer.newLine();
            }
            writer.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeOutput(sw.toString());
    }

    @Override
    public <T> void traceBeanResolved(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, T bean) {
        String prefix = ConsoleBeanResolutionTracer.padLeft(resolutionContext, 1) + RIGHT_ARROW;
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            writer.write(prefix);
            writer.write(bean != null ? "\u2705 " : "\u274c ");
            if (bean != null) {
                if (qualifier != null) {
                    if (qualifier instanceof Named) {
                        Named named = (Named)qualifier;
                        writer.write(AnsiColour.yellow((String)"@Named("));
                        writer.write(AnsiColour.green((String)("\"" + named.getName() + "\"")));
                        writer.write(AnsiColour.yellow((String)")"));
                    } else {
                        writer.write(AnsiColour.yellow((String)qualifier.toString()));
                    }
                    writer.write(" ");
                }
                writer.write(AnsiColour.formatObject(bean));
            } else {
                writer.write("Bean of type ");
                writer.write(beanType.getBeanTypeString(TypeInformation.TypeFormat.ANSI_SIMPLE));
                writer.write(" does not exist.");
            }
            writer.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeOutput(sw.toString());
    }

    @Override
    public <T> void traceBeanDisabled(BeanResolutionContext resolutionContext, Argument<T> beanType, Qualifier<T> qualifier, String disabledBeanMessage) {
        String[] lines = disabledBeanMessage.split("\\r?\\n");
        String prefix = ConsoleBeanResolutionTracer.padLeft(resolutionContext, 3);
        StringWriter sw = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(sw);){
            for (String line : lines) {
                if (!StringUtils.isNotEmpty((CharSequence)line.trim())) continue;
                writer.write(prefix);
                if (line.startsWith("*")) {
                    writer.write("\u274c ");
                    writer.write(line.substring(1));
                    writer.newLine();
                    continue;
                }
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeOutput(sw.toString());
    }

    @Override
    public <T> void traceValueResolved(BeanResolutionContext resolutionContext, Argument<T> argument, String property, T value) {
        BeanContext context = resolutionContext.getContext();
        if (context instanceof ApplicationContext) {
            ApplicationContext applicationContext = (ApplicationContext)context;
            Environment environment = applicationContext.getEnvironment();
            PropertySource.Origin origin = environment.getPropertyEntry(property).map(PropertyEntry::origin).orElse(null);
            String prefix = ConsoleBeanResolutionTracer.padLeft(resolutionContext, 1) + RIGHT_ARROW;
            StringWriter sw = new StringWriter();
            try (BufferedWriter writer = new BufferedWriter(sw);){
                writer.write(prefix);
                writer.write(AnsiColour.formatObject((Object)property));
                writer.write(" = ");
                writer.write(AnsiColour.formatObject(value));
                if (origin != null) {
                    writer.write(" (Origin: " + AnsiColour.brightYellow((String)origin.location()) + ")");
                }
                writer.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writeOutput(sw.toString());
        }
    }

    @Override
    public <T> void traceBeanCreated(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition) {
        Object v = resolutionContext.getAttribute(START_TIME);
        if (v instanceof Long) {
            Long start = (Long)v;
            StringWriter sw = new StringWriter();
            try (BufferedWriter writer = new BufferedWriter(sw);){
                writer.newLine();
                String beanName = beanDefinition.getBeanDescription(TypeInformation.TypeFormat.ANSI_SIMPLE, false);
                long now = System.currentTimeMillis();
                writer.write("\u2705 Created " + beanName + " in " + (now - start) + "ms");
                writer.newLine();
                writer.write("------------");
                writer.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writeOutput(sw.toString());
        }
    }

    @Override
    public <B, T> void traceInjectBean(BeanResolutionContext resolutionContext, BeanResolutionContext.Segment<B, T> segment) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        if (segment.getDeclaringType() != null && segment.getDeclaringType().getBeanType().isSynthetic() && segment.getArgument().getName().startsWith("$")) {
            return;
        }
        int size = path.size();
        Object prefix = "";
        if (size > 1) {
            String spaces = "   ".repeat(size);
            prefix = spaces + RIGHT_ARROW_LOOP;
        }
        String content = (String)prefix + segment.toConsoleString(AnsiColour.isSupported());
        this.writeOutput(content);
    }

    private static String getBeanName(Argument<?> beanType, BeanDefinition<?> beanDefinition) {
        String beanName = beanType.getType().isSynthetic() ? beanDefinition.getTypeInformation().getBeanTypeString(TypeInformation.TypeFormat.ANSI_SIMPLE) : beanType.getBeanTypeString(TypeInformation.TypeFormat.ANSI_SIMPLE);
        return beanName;
    }

    @NonNull
    private static String padLeft(BeanResolutionContext resolutionContext, int amount) {
        int size = resolutionContext.getPath().size() + amount;
        String prefix = "";
        if (size > 1) {
            prefix = "   ".repeat(size);
        }
        return prefix;
    }

    static final class SystemOutBeanResolutionTracer
    extends ConsoleBeanResolutionTracer {
        SystemOutBeanResolutionTracer() {
        }

        @Override
        protected void writeOutput(String output) {
            System.out.println(output);
        }
    }

    static final class LoggingBeanResolutionTracer
    extends ConsoleBeanResolutionTracer {
        static final Logger LOGGER = LoggerFactory.getLogger((String)"io.micronaut.inject");

        LoggingBeanResolutionTracer() {
        }

        @Override
        protected void writeOutput(String output) {
            LOGGER.trace(output);
        }
    }
}

