/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import java.util.Collection;
import java.util.Optional;

public interface BeanDefinitionRegistry {
    public <T> boolean containsBean(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> BeanDefinitionRegistry registerSingleton(@NonNull Class<T> var1, @NonNull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @NonNull
    public Optional<BeanConfiguration> findBeanConfiguration(@NonNull String var1);

    @NonNull
    public <T> Optional<BeanDefinition<T>> findBeanDefinition(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Optional<BeanRegistration<T>> findBeanRegistration(@NonNull T var1);

    @NonNull
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(@NonNull Class<T> var1);

    @NonNull
    public <T> Collection<BeanDefinition<T>> getBeanDefinitions(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public Collection<BeanDefinition<?>> getBeanDefinitions(@NonNull Qualifier<Object> var1);

    @NonNull
    public Collection<BeanDefinition<?>> getAllBeanDefinitions();

    @NonNull
    public Collection<BeanDefinitionReference<?>> getBeanDefinitionReferences();

    @NonNull
    public Collection<BeanRegistration<?>> getActiveBeanRegistrations(@NonNull Qualifier<?> var1);

    @NonNull
    public <T> Collection<BeanRegistration<T>> getActiveBeanRegistrations(@NonNull Class<T> var1);

    @NonNull
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@NonNull Class<T> var1);

    @NonNull
    public <T> Collection<BeanRegistration<T>> getBeanRegistrations(@NonNull Class<T> var1, @NonNull Qualifier<T> var2);

    @NonNull
    public <T> BeanRegistration<T> getBeanRegistration(@NonNull Class<T> var1, @NonNull Qualifier<T> var2);

    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyTargetBeanDefinition(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    public <T> Optional<BeanDefinition<T>> findProxyBeanDefinition(@NonNull Class<T> var1, @Nullable Qualifier<T> var2);

    @NonNull
    default public <T> BeanDefinitionRegistry registerSingleton(@NonNull Class<T> type, @NonNull T singleton, @Nullable Qualifier<T> qualifier) {
        return this.registerSingleton(type, singleton, qualifier, true);
    }

    default public <T> BeanDefinitionRegistry registerSingleton(@NonNull Class<T> type, @NonNull T singleton) {
        return this.registerSingleton(type, singleton, null);
    }

    @NonNull
    default public <T> BeanDefinition<T> getBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @NonNull
    default public <T> BeanDefinition<T> getProxyTargetBeanDefinition(@NonNull Class<T> beanType, @Nullable Qualifier<T> qualifier) {
        return this.findProxyTargetBeanDefinition(beanType, qualifier).orElseThrow(() -> new NoSuchBeanException(beanType, qualifier));
    }

    @NonNull
    default public <T> BeanDefinition<T> getBeanDefinition(@NonNull Class<T> beanType) {
        return this.findBeanDefinition(beanType, null).orElseThrow(() -> new NoSuchBeanException(beanType));
    }

    @NonNull
    default public <T> Optional<BeanDefinition<T>> findBeanDefinition(@NonNull Class<T> beanType) {
        return this.findBeanDefinition(beanType, null);
    }

    @NonNull
    default public BeanDefinitionRegistry registerSingleton(@NonNull Object singleton) {
        ArgumentUtils.requireNonNull((String)"singleton", (Object)singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton);
    }

    @NonNull
    default public BeanDefinitionRegistry registerSingleton(@NonNull Object singleton, boolean inject) {
        ArgumentUtils.requireNonNull((String)"singleton", (Object)singleton);
        Class<?> type = singleton.getClass();
        return this.registerSingleton(type, singleton, null, inject);
    }

    default public boolean containsBean(@NonNull Class beanType) {
        return beanType != null && this.containsBean(beanType, null);
    }
}

