/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.util.functional.ThrowingConsumer;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.netty.body.AvailableNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Internal
public final class NettyByteBodyFactory
extends ByteBodyFactory {
    public NettyByteBodyFactory(@NonNull Channel channel) {
        super((ByteBufferFactory)new NettyByteBufferFactory(channel.alloc()));
    }

    private ByteBufAllocator alloc() {
        return (ByteBufAllocator)this.byteBufferFactory().getNativeAllocator();
    }

    @NonNull
    public CloseableAvailableByteBody adapt(@NonNull ByteBuffer<?> buffer) {
        Object object = buffer.asNativeBuffer();
        if (object instanceof ByteBuf) {
            ByteBuf bb = (ByteBuf)object;
            return new AvailableNettyByteBody(bb);
        }
        return super.adapt(buffer);
    }

    @NonNull
    public CloseableAvailableByteBody adapt(byte @NonNull [] array) {
        return new AvailableNettyByteBody(Unpooled.wrappedBuffer((byte[])array));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T extends Throwable> CloseableAvailableByteBody buffer(@NonNull ThrowingConsumer<? super OutputStream, T> writer) throws T {
        ByteBuf buf = this.alloc().buffer();
        boolean release = true;
        try {
            ByteBufOutputStream s = new ByteBufOutputStream(buf);
            writer.accept((Object)s);
            try {
                s.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to close buffer stream", e);
            }
            release = false;
            AvailableNettyByteBody availableNettyByteBody = new AvailableNettyByteBody(buf);
            return availableNettyByteBody;
        }
        finally {
            if (release) {
                buf.release();
            }
        }
    }

    @NonNull
    public CloseableAvailableByteBody createEmpty() {
        return AvailableNettyByteBody.empty();
    }

    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        ByteBuf byteBuf = charset == StandardCharsets.UTF_8 ? ByteBufUtil.writeUtf8((ByteBufAllocator)this.alloc(), (CharSequence)cs) : ByteBufUtil.encodeString((ByteBufAllocator)this.alloc(), (CharBuffer)CharBuffer.wrap(cs), (Charset)charset);
        return new AvailableNettyByteBody(byteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull InputStream stream) throws IOException {
        ByteBuf buffer = this.alloc().buffer();
        boolean free = true;
        try {
            while (buffer.writeBytes(stream, 4096) != -1) {
            }
            free = false;
            AvailableNettyByteBody availableNettyByteBody = new AvailableNettyByteBody(buffer);
            return availableNettyByteBody;
        }
        finally {
            if (free) {
                buffer.release();
            }
        }
    }
}

