/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.ConstructorInterceptor;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InterceptorRegistry;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.chain.AbstractInterceptorChain;
import io.micronaut.aop.chain.AdapterIntroduction;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanContextConfigurable;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.naming.Described;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.inject.ExecutableMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterceptorRegistry
implements InterceptorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private static final MethodInterceptor<?, ?>[] ZERO_METHOD_INTERCEPTORS = new MethodInterceptor[0];
    private static final Interceptor[] ZERO_INTERCEPTORS = new Interceptor[0];
    private final BeanContext beanContext;

    public DefaultInterceptorRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    @NonNull
    public <T> Interceptor<T, ?>[] resolveInterceptors(@NonNull Executable<T, ?> method, @NonNull Collection<BeanRegistration<Interceptor<T, ?>>> interceptors, @NonNull InterceptorKind interceptorKind) {
        AnnotationMetadata annotationMetadata = method.getAnnotationMetadata();
        if (interceptors.isEmpty()) {
            return this.resolveToNone((ExecutableMethod)method, interceptorKind, annotationMetadata);
        }
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, method);
        Collection<AnnotationValue<?>> applicableBindings = AbstractInterceptorChain.resolveInterceptorValues(annotationMetadata, interceptorKind);
        if (applicableBindings.isEmpty()) {
            return this.resolveToNone((ExecutableMethod)method, interceptorKind, annotationMetadata);
        }
        Interceptor<T, ?>[] resolvedInterceptors = this.findInterceptors(method.getDeclaringType(), interceptors, interceptorKind, applicableBindings, true, false);
        if (LOG.isTraceEnabled()) {
            String string;
            Object[] objectArray = new Object[5];
            objectArray[0] = resolvedInterceptors.length;
            objectArray[1] = interceptorKind;
            objectArray[2] = interceptors.size();
            objectArray[3] = method.getDeclaringType();
            if (method instanceof Described) {
                Described d = (Described)method;
                string = d.getDescription(true);
            } else {
                string = method.toString();
            }
            objectArray[4] = string;
            LOG.trace("Resolved {} {} interceptors out of a possible {} for method: {} - {}", objectArray);
            for (int i = 0; i < resolvedInterceptors.length; ++i) {
                Interceptor<T, ?> resolvedInterceptor = resolvedInterceptors[i];
                LOG.trace("Interceptor {} - {}", (Object)i, resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private Interceptor[] resolveToNone(ExecutableMethod<?, ?> method, InterceptorKind interceptorKind, AnnotationMetadata annotationMetadata) {
        if (interceptorKind == InterceptorKind.INTRODUCTION) {
            if (annotationMetadata.hasStereotype(Adapter.class)) {
                return new MethodInterceptor[]{new AdapterIntroduction(this.beanContext, method)};
            }
            throw new IllegalStateException("At least one @Introduction method interceptor required, but missing for method: " + method.getDescription(true) + ". Check if your @Introduction stereotype annotation is marked with @Retention(RUNTIME) and @InterceptorBean(..) with the interceptor type. Otherwise do not load @Introduction beans if their interceptor definitions are missing!");
        }
        return ZERO_METHOD_INTERCEPTORS;
    }

    private <T> Interceptor<T, ?>[] findInterceptors(Class<?> declaringType, Collection<BeanRegistration<Interceptor<T, ?>>> interceptors, InterceptorKind interceptorKind, Collection<AnnotationValue<?>> interceptPointBindings, boolean selectMethodInterceptor, boolean selectConstructorInterceptor) {
        ArrayList selectedInterceptorRegistrations = new ArrayList(interceptors.size());
        for (BeanRegistration<Interceptor<T, ?>> beanRegistration : interceptors) {
            if (!this.selectInterceptor(declaringType, interceptorKind, interceptPointBindings, beanRegistration)) continue;
            selectedInterceptorRegistrations.add(beanRegistration);
        }
        selectedInterceptorRegistrations.sort(OrderUtil.ORDERED_COMPARATOR);
        ArrayList<Interceptor> selectedInterceptors = new ArrayList<Interceptor>(selectedInterceptorRegistrations.size());
        for (BeanRegistration beanRegistration : selectedInterceptorRegistrations) {
            Interceptor bean = (Interceptor)beanRegistration.getBean();
            if ((!selectMethodInterceptor || !(bean instanceof MethodInterceptor) && bean instanceof ConstructorInterceptor) && (!selectConstructorInterceptor || !(bean instanceof ConstructorInterceptor) && bean instanceof MethodInterceptor)) continue;
            selectedInterceptors.add(bean);
        }
        return selectedInterceptors.toArray(ZERO_INTERCEPTORS);
    }

    private <T> boolean selectInterceptor(Class<?> declaringType, InterceptorKind interceptorKind, Collection<AnnotationValue<?>> interceptPointBindings, BeanRegistration<Interceptor<T, ?>> beanRegistration) {
        Object applicableType;
        List typeArgs = beanRegistration.getBeanDefinition().getTypeArguments(ConstructorInterceptor.class);
        if (!typeArgs.isEmpty() && !((Class)(applicableType = ((Argument)typeArgs.iterator().next()).getType())).isAssignableFrom(declaringType)) {
            return false;
        }
        for (AnnotationValue annotationValue : interceptPointBindings) {
            if (!this.isApplicableByType(beanRegistration, annotationValue)) continue;
            return true;
        }
        Collection<AnnotationValue<?>> interceptorValues = AbstractInterceptorChain.resolveInterceptorValues(beanRegistration.getBeanDefinition().getAnnotationMetadata(), interceptorKind);
        if (interceptorValues.isEmpty()) {
            return false;
        }
        for (AnnotationValue<?> interceptorAnnotationValue : interceptorValues) {
            if (this.matches(interceptorAnnotationValue, interceptPointBindings)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(AnnotationValue<?> interceptorAnnotationValue, Collection<AnnotationValue<?>> interceptPointBindings) {
        AnnotationValue memberBinding = interceptorAnnotationValue.getAnnotation("$bindingValues").orElse(null);
        String annotationName = interceptorAnnotationValue.stringValue().orElse(null);
        if (annotationName == null) {
            return false;
        }
        for (AnnotationValue<?> applicableValue : interceptPointBindings) {
            String interceptPointAnnotation = applicableValue.stringValue().orElse(null);
            if (!annotationName.equals(interceptPointAnnotation)) continue;
            if (memberBinding == null) {
                return true;
            }
            AnnotationValue otherMembers = applicableValue.getAnnotation("$bindingValues").orElse(null);
            if (!memberBinding.equals((Object)otherMembers)) continue;
            return true;
        }
        return false;
    }

    private <T> boolean isApplicableByType(BeanRegistration<Interceptor<T, ?>> beanRegistration, AnnotationValue<?> applicableValue) {
        AnnotationClassValue interceptorType = applicableValue.annotationClassValue("interceptorType").orElse(null);
        if (interceptorType == null) {
            return false;
        }
        Class type = interceptorType.getType().orElse(null);
        if (type != null) {
            return type.isInstance(beanRegistration.getBean());
        }
        return interceptorType.getName().equals(((Interceptor)beanRegistration.getBean()).getClass().getName());
    }

    @Override
    @NonNull
    public <T> Interceptor<T, T>[] resolveConstructorInterceptors(@NonNull BeanConstructor<T> constructor, @NonNull Collection<BeanRegistration<Interceptor<T, T>>> interceptors) {
        DefaultInterceptorRegistry.instrumentAnnotationMetadata(this.beanContext, constructor);
        Collection<AnnotationValue<?>> applicableBindings = AbstractInterceptorChain.resolveInterceptorValues(constructor.getAnnotationMetadata(), InterceptorKind.AROUND_CONSTRUCT);
        Interceptor<T, ?>[] resolvedInterceptors = this.findInterceptors(constructor.getDeclaringBeanType(), interceptors, InterceptorKind.AROUND_CONSTRUCT, applicableBindings, false, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resolved {} {} interceptors out of a possible {} for constructor: {} - {}", new Object[]{resolvedInterceptors.length, InterceptorKind.AROUND_CONSTRUCT, interceptors.size(), constructor.getDeclaringBeanType(), constructor.getDescription(true)});
            for (int i = 0; i < resolvedInterceptors.length; ++i) {
                Interceptor<T, ?> resolvedInterceptor = resolvedInterceptors[i];
                LOG.trace("Interceptor {} - {}", (Object)i, resolvedInterceptor);
            }
        }
        return resolvedInterceptors;
    }

    private static void instrumentAnnotationMetadata(BeanContext beanContext, Object method) {
        if (method instanceof BeanContextConfigurable) {
            BeanContextConfigurable ctxConfigurable = (BeanContextConfigurable)method;
            ctxConfigurable.configure(beanContext);
        }
        if (beanContext instanceof ApplicationContext) {
            EnvironmentConfigurable environmentConfigurable;
            ApplicationContext applicationContext = (ApplicationContext)beanContext;
            if (method instanceof EnvironmentConfigurable && (environmentConfigurable = (EnvironmentConfigurable)method).hasPropertyExpressions()) {
                environmentConfigurable.configure(applicationContext.getEnvironment());
            }
        }
    }
}

