/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.buffers.BufferData;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http1.Http1Connection;
import io.helidon.webserver.http1.Http1ConnectionSelectorConfig;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=Http1ConnectionSelectorConfig.class)
public class Http1ConnectionSelector
implements ServerConnectionSelector,
RuntimeType.Api<Http1ConnectionSelectorConfig> {
    private static final String PROTOCOL = " HTTP/1.1\r";
    private final Http1ConnectionSelectorConfig config;
    private final Map<String, Http1Upgrader> upgradeProviderMap;

    Http1ConnectionSelector(Http1ConnectionSelectorConfig config) {
        this.config = config;
        this.upgradeProviderMap = config.upgraders();
    }

    public static Http1ConnectionSelectorConfig.Builder builder() {
        return Http1ConnectionSelectorConfig.builder();
    }

    static Http1ConnectionSelector create(Http1ConnectionSelectorConfig config) {
        return new Http1ConnectionSelector(config);
    }

    static Http1ConnectionSelector create(Consumer<Http1ConnectionSelectorConfig.Builder> consumer) {
        return ((Http1ConnectionSelectorConfig.Builder)Http1ConnectionSelector.builder().update(consumer)).build();
    }

    @Override
    public int bytesToIdentifyConnection() {
        return 0;
    }

    @Override
    public ServerConnectionSelector.Support supports(BufferData request) {
        int lf = request.indexOf((byte)10);
        if (lf == -1) {
            return request.available() <= this.config.config().maxPrologueLength() ? ServerConnectionSelector.Support.SUPPORTED : ServerConnectionSelector.Support.UNSUPPORTED;
        }
        return request.readString(lf).endsWith(PROTOCOL) ? ServerConnectionSelector.Support.SUPPORTED : ServerConnectionSelector.Support.UNSUPPORTED;
    }

    @Override
    public Set<String> supportedApplicationProtocols() {
        return Set.of("http/1.1");
    }

    @Override
    public ServerConnection connection(ConnectionContext ctx) {
        return new Http1Connection(ctx, this.config.config(), this.upgradeProviderMap);
    }

    public Http1ConnectionSelectorConfig prototype() {
        return this.config;
    }
}

