/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http1.Http1BuilderDecorator;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.spi.ProtocolConfig;
import java.util.List;

@Prototype.Blueprint(decorator=Http1BuilderDecorator.class)
@Configured(provides={ProtocolConfig.class})
interface Http1ConfigBlueprint
extends ProtocolConfig {
    public String name();

    @ConfiguredOption(value="2048")
    public int maxPrologueLength();

    @ConfiguredOption(value="16384")
    public int maxHeadersSize();

    @ConfiguredOption(value="true")
    public boolean validateRequestHeaders();

    @ConfiguredOption(value="false")
    public boolean validateResponseHeaders();

    @ConfiguredOption(value="true")
    public boolean validatePath();

    @ConfiguredOption(key="recv-log", value="true")
    public boolean receiveLog();

    @ConfiguredOption(value="true")
    public boolean sendLog();

    @ConfiguredOption(value="false")
    public boolean continueImmediately();

    @ConfiguredOption
    public RequestedUriDiscoveryContext requestedUriDiscovery();

    @Option.Singular
    public List<Http1ConnectionListener> sendListeners();

    @Option.Singular
    public List<Http1ConnectionListener> receiveListeners();

    public Http1ConnectionListener compositeSendListener();

    public Http1ConnectionListener compositeReceiveListener();

    default public String type() {
        return "http_1_1";
    }
}

