/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatchers;
import io.helidon.http.RoutedPath;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouteBase;
import io.helidon.webserver.http.RoutingRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class RouteCrawler {
    private final ConnectionContext ctx;
    private final RoutingRequest request;
    private final Iterator<HttpRouteBase> routeIterator;
    private final UriPath matchingPath;
    private final RoutedPath parent;
    private final HttpPrologue prologue;
    private CrawlerItem next;
    private RouteCrawler subCrawler;

    RouteCrawler(ConnectionContext ctx, RoutingRequest request, List<HttpRouteBase> rootRoute) {
        this.ctx = ctx;
        this.routeIterator = rootRoute.iterator();
        this.matchingPath = request.prologue().uriPath();
        this.prologue = request.prologue();
        this.request = request;
        this.parent = null;
    }

    RouteCrawler(ConnectionContext ctx, RoutingRequest request, List<HttpRouteBase> rootRoute, RoutedPath parent, UriPath child) {
        this.ctx = ctx;
        this.routeIterator = rootRoute.iterator();
        this.matchingPath = child;
        this.request = request;
        this.parent = parent;
        HttpPrologue prologue = request.prologue();
        this.prologue = HttpPrologue.create((String)prologue.rawProtocol(), (String)prologue.protocol(), (String)prologue.protocolVersion(), (Method)prologue.method(), (UriPath)child, (UriQuery)prologue.query(), (UriFragment)prologue.fragment());
    }

    boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.subCrawler != null && this.subCrawler.hasNext()) {
            this.next = this.subCrawler.next();
            if (this.parent != null) {
                this.next = this.next.parent(this.parent);
            }
            return true;
        }
        while (this.routeIterator.hasNext()) {
            PathMatchers.PrefixMatchResult accepts;
            HttpRouteBase nextRoute = this.routeIterator.next();
            if (nextRoute.isList()) {
                accepts = nextRoute.acceptsPrefix(this.prologue);
                if (!accepts.accepted()) continue;
                this.subCrawler = new RouteCrawler(this.ctx, this.request, nextRoute.routes(), accepts.matchedPath(), accepts.unmatchedPath());
                if (this.subCrawler.hasNext()) {
                    this.next = this.subCrawler.next();
                    if (this.parent != null) {
                        this.next = this.next.parent(this.parent);
                    }
                    return true;
                }
                this.subCrawler = null;
                continue;
            }
            accepts = nextRoute.accepts(this.prologue);
            if (!accepts.accepted()) continue;
            this.next = new CrawlerItem(accepts.path(), nextRoute.handler());
            if (this.parent != null) {
                this.next = this.next.parent(this.parent);
            }
            return true;
        }
        return false;
    }

    CrawlerItem next() {
        CrawlerItem result = this.next;
        this.next = null;
        return result;
    }

    record CrawlerItem(RoutedPath path, Handler handler) {
        public CrawlerItem parent(RoutedPath parent) {
            HashMap<String, List> newParams = new HashMap<String, List>();
            Parameters params = parent.pathParameters();
            for (String paramName : params.names()) {
                newParams.put(paramName, params.all(paramName));
            }
            params = this.path.pathParameters();
            for (String paramName : params.names()) {
                newParams.put(paramName, params.all(paramName));
            }
            newParams.replaceAll((name, values) -> List.copyOf(values));
            CrawlerRoutedPath result = new CrawlerRoutedPath((UriPath)this.path, Parameters.create((String)"http/path", newParams));
            return new CrawlerItem(result, this.handler);
        }

        private static final class CrawlerRoutedPath
        implements RoutedPath {
            private final UriPath path;
            private final Parameters templateParams;

            private CrawlerRoutedPath(UriPath path, Parameters templateParams) {
                this.path = path;
                this.templateParams = templateParams;
            }

            public String rawPath() {
                return this.path.rawPath();
            }

            public String rawPathNoParams() {
                return this.path.rawPathNoParams();
            }

            public String path() {
                return this.path.path();
            }

            public Parameters matrixParameters() {
                return this.path.matrixParameters();
            }

            public void validate() {
                this.path.validate();
            }

            public Parameters pathParameters() {
                return this.templateParams;
            }

            public RoutedPath absolute() {
                return new CrawlerRoutedPath(this.path.absolute(), this.templateParams);
            }
        }
    }
}

