/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.context.Context;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.task.HelidonTaskExecutor;
import io.helidon.common.task.InterruptableTask;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionHandler;
import io.helidon.webserver.ConnectionProviders;
import io.helidon.webserver.IdleTimeoutHandler;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.NoopSemaphore;
import io.helidon.webserver.ProtocolConfigs;
import io.helidon.webserver.Router;
import io.helidon.webserver.ThreadPerTaskExecutor;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.spi.ServerConnectionSelector;
import io.helidon.webserver.spi.ServerConnectionSelectorProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;

class ServerListener
implements ListenerContext {
    private static final System.Logger LOGGER = System.getLogger(ServerListener.class.getName());
    private static final LazyValue<List<ServerConnectionSelectorProvider>> SELECTOR_PROVIDERS = LazyValue.create(() -> HelidonServiceLoader.create(ServiceLoader.load(ServerConnectionSelectorProvider.class)).asList());
    private final ConnectionProviders connectionProviders;
    private final String socketName;
    private final ListenerConfig listenerConfig;
    private final Router router;
    private final HelidonTaskExecutor readerExecutor;
    private final ExecutorService sharedExecutor;
    private final Thread serverThread;
    private final DirectHandlers directHandlers;
    private final CompletableFuture<Void> closeFuture;
    private final Tls tls;
    private final SocketOptions connectionOptions;
    private final InetSocketAddress configuredAddress;
    private final Duration gracePeriod;
    private final MediaContext mediaContext;
    private final ContentEncodingContext contentEncodingContext;
    private final Context context;
    private final Semaphore connectionSemaphore;
    private final Semaphore requestSemaphore;
    private final Map<String, ServerConnection> activeConnections = new ConcurrentHashMap<String, ServerConnection>();
    private volatile boolean running;
    private volatile int connectedPort;
    private volatile ServerSocket serverSocket;

    ServerListener(String socketName, ListenerConfig listenerConfig, Router router, Context serverContext, Timer idleConnectionTimer, MediaContext defaultMediaContext, ContentEncodingContext defaultContentEncodingContext, DirectHandlers defaultDirectHandlers) {
        ProtocolConfigs protocols = ProtocolConfigs.create(listenerConfig.protocols());
        ArrayList<ServerConnectionSelector> selectors = new ArrayList<ServerConnectionSelector>(listenerConfig.connectionSelectors());
        ((List)SELECTOR_PROVIDERS.get()).forEach(provider -> {
            List configurations = protocols.config(provider.protocolType(), provider.protocolConfigType());
            for (ProtocolConfig configuration : configurations) {
                selectors.add(provider.create(socketName, configuration, protocols));
            }
        });
        this.connectionSemaphore = listenerConfig.maxTcpConnections() == -1 ? new NoopSemaphore() : new Semaphore(listenerConfig.maxTcpConnections());
        this.requestSemaphore = listenerConfig.maxConcurrentRequests() == -1 ? new NoopSemaphore() : new Semaphore(listenerConfig.maxConcurrentRequests());
        this.connectionProviders = ConnectionProviders.create(selectors);
        this.socketName = socketName;
        this.listenerConfig = listenerConfig;
        this.tls = listenerConfig.tls().orElseGet(() -> ((TlsConfig.Builder)Tls.builder().enabled(false)).build());
        this.connectionOptions = listenerConfig.connectionOptions();
        this.directHandlers = listenerConfig.directHandlers().orElse(defaultDirectHandlers);
        this.mediaContext = listenerConfig.mediaContext().orElse(defaultMediaContext);
        this.contentEncodingContext = listenerConfig.contentEncoding().orElse(defaultContentEncodingContext);
        this.context = listenerConfig.listenerContext().orElseGet(() -> Context.builder().id("listener-" + socketName).parent(serverContext).build());
        this.gracePeriod = listenerConfig.shutdownGracePeriod();
        this.serverThread = Thread.ofPlatform().inheritInheritableThreadLocals(true).daemon(false).name("server-" + socketName + "-listener").unstarted(this::listen);
        this.readerExecutor = ThreadPerTaskExecutor.create(Thread.ofVirtual().factory());
        this.sharedExecutor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().factory());
        this.closeFuture = new CompletableFuture();
        int port = listenerConfig.port();
        if (port < 1) {
            port = 0;
        }
        this.configuredAddress = new InetSocketAddress(listenerConfig.address(), port);
        this.router = router;
        IdleTimeoutHandler ith = new IdleTimeoutHandler(idleConnectionTimer, listenerConfig, this::activeConnections);
        ith.start();
    }

    @Override
    public MediaContext mediaContext() {
        return this.mediaContext;
    }

    @Override
    public ContentEncodingContext contentEncodingContext() {
        return this.contentEncodingContext;
    }

    @Override
    public DirectHandlers directHandlers() {
        return this.directHandlers;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public ListenerConfig config() {
        return this.listenerConfig;
    }

    @Override
    public ExecutorService executor() {
        return this.sharedExecutor;
    }

    public String toString() {
        return this.socketName + " (" + String.valueOf(this.configuredAddress) + ")";
    }

    int port() {
        return this.connectedPort;
    }

    InetSocketAddress configuredAddress() {
        return this.configuredAddress;
    }

    void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
            this.readerExecutor.terminate(this.gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
            if (!this.readerExecutor.isTerminated()) {
                LOGGER.log(System.Logger.Level.DEBUG, "Some tasks in reader executor did not terminate gracefully");
                this.readerExecutor.forceTerminate();
            }
            try {
                List<Runnable> running;
                this.sharedExecutor.shutdown();
                boolean done = this.sharedExecutor.awaitTermination(this.gracePeriod.toMillis(), TimeUnit.MILLISECONDS);
                if (!done && !(running = this.sharedExecutor.shutdownNow()).isEmpty()) {
                    LOGGER.log(System.Logger.Level.DEBUG, running.size() + " tasks in shared executor did not terminate gracefully");
                }
            }
            catch (InterruptedException done) {}
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.INFO, "Exception thrown on socket close", (Throwable)e);
        }
        this.serverThread.interrupt();
        this.closeFuture.join();
        this.router.afterStop();
    }

    void start() {
        this.router.beforeStart();
        try {
            SSLServerSocket sslServerSocket = this.tls.enabled() ? this.tls.createServerSocket() : null;
            this.serverSocket = this.tls.enabled() ? sslServerSocket : new ServerSocket();
            this.listenerConfig.configureSocket(this.serverSocket);
            this.serverSocket.bind(this.configuredAddress, this.listenerConfig.backlog());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to start server", e);
        }
        String serverChannelId = "0x" + HexFormat.of().toHexDigits(System.identityHashCode(this.serverSocket));
        this.running = true;
        InetAddress inetAddress = this.serverSocket.getInetAddress();
        this.connectedPort = this.serverSocket.getLocalPort();
        if (LOGGER.isLoggable(System.Logger.Level.INFO)) {
            String format = this.tls.enabled() ? "[%s] https://%s:%s bound for socket '%s'" : "[%s] http://%s:%s bound for socket '%s'";
            LOGGER.log(System.Logger.Level.INFO, String.format(format, serverChannelId, inetAddress.getHostAddress(), this.connectedPort, this.socketName));
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                if (this.listenerConfig.writeQueueLength() <= 1) {
                    LOGGER.log(System.Logger.Level.TRACE, "[" + serverChannelId + "] direct writes");
                } else {
                    LOGGER.log(System.Logger.Level.TRACE, "[" + serverChannelId + "] async writes, queue length: " + this.listenerConfig.writeQueueLength());
                }
                if (this.tls.enabled()) {
                    this.debugTls(serverChannelId, this.tls);
                }
            }
        }
        this.serverThread.start();
    }

    boolean hasTls() {
        return this.tls.enabled();
    }

    void reloadTls(Tls tls) {
        if (!this.tls.enabled()) {
            throw new IllegalArgumentException("TLS is not enabled on the socket " + this.socketName + " and therefore cannot be reloaded");
        }
        if (!tls.enabled()) {
            throw new UnsupportedOperationException("TLS cannot be disabled by reloading on the socket " + this.socketName);
        }
        this.tls.reload(tls);
    }

    private void debugTls(String serverChannelId, Tls tls) {
        SSLParameters sslParameters = tls.newEngine().getSSLParameters();
        String message = "[" + serverChannelId + "] TLS configuration of socket " + this.socketName + "\nProtocols: " + Arrays.toString(sslParameters.getProtocols()) + "\nCipher Suites: " + Arrays.toString(sslParameters.getCipherSuites()) + "\nEndpoint identification algorithm: " + sslParameters.getEndpointIdentificationAlgorithm() + "\nNeed client auth: " + sslParameters.getNeedClientAuth() + "\nWant client auth: " + sslParameters.getWantClientAuth();
        LOGGER.log(System.Logger.Level.TRACE, message);
    }

    private void listen() {
        String serverChannelId = "0x" + HexFormat.of().toHexDigits(System.identityHashCode(this.serverSocket));
        while (this.running) {
            try {
                this.connectionSemaphore.acquire();
                Socket socket = this.serverSocket.accept();
                try {
                    this.connectionOptions.configureSocket(socket);
                    ConnectionHandler handler = new ConnectionHandler(this, this.connectionSemaphore, this.requestSemaphore, this.connectionProviders, this.activeConnections, socket, serverChannelId, this.router, this.tls);
                    this.readerExecutor.execute((InterruptableTask)handler);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.log(System.Logger.Level.ERROR, "Executor rejected handler for new connection");
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(System.Logger.Level.TRACE, "Failed to close socket that was rejected for execution", (Throwable)e);
                    }
                    this.connectionSemaphore.release();
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.TRACE, "Failed to handle accepted socket", (Throwable)e);
                    try {
                        socket.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(System.Logger.Level.TRACE, "Failed to close socket that failed start execution (see previous trace for reason)", (Throwable)e);
                    }
                    this.connectionSemaphore.release();
                }
            }
            catch (SocketException e) {
                if (!e.getMessage().contains("Socket closed")) {
                    LOGGER.log(System.Logger.Level.ERROR, "Got a socket exception while listening, this server socket is terminating now", (Throwable)e);
                }
                if (!this.running) continue;
                this.stop();
            }
            catch (Throwable e) {
                LOGGER.log(System.Logger.Level.ERROR, "Got a throwable while listening, this server socket is terminating now", e);
                if (!this.running) continue;
                this.stop();
            }
        }
        LOGGER.log(System.Logger.Level.INFO, String.format("[%s] %s socket closed.", serverChannelId, this.socketName));
        this.closeFuture.complete(null);
    }

    private List<ServerConnection> activeConnections() {
        return new ArrayList<ServerConnection>(this.activeConnections.values());
    }
}

