/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.ConnectionConfigBlueprint;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.ConnectionConfigBlueprint")
public interface ConnectionConfig
extends ConnectionConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectionConfig instance) {
        return (Builder)ConnectionConfig.builder().from(instance);
    }

    public static ConnectionConfig create(Config config) {
        return ((Builder)ConnectionConfig.builder().config(config)).buildPrototype();
    }

    public static ConnectionConfig create() {
        return ConnectionConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ConnectionConfig>
    implements io.helidon.common.Builder<Builder, ConnectionConfig> {
        private Builder() {
        }

        public ConnectionConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ConnectionConfigImpl(this);
        }

        public ConnectionConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ConnectionConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<SocketOption<?>, Object> socketOptions = new LinkedHashMap();
        private boolean keepAlive = true;
        private boolean reuseAddress = true;
        private boolean tcpNoDelay = false;
        private Config config;
        private Duration connectTimeout = Duration.parse("PT10S");
        private Duration readTimeout = Duration.parse("PT30S");
        private int receiveBufferSize = 32768;
        private int sendBufferSize = 32768;

        protected BuilderBase() {
        }

        public BUILDER from(ConnectionConfig prototype) {
            this.readTimeout(prototype.readTimeout());
            this.connectTimeout(prototype.connectTimeout());
            this.sendBufferSize(prototype.sendBufferSize());
            this.receiveBufferSize(prototype.receiveBufferSize());
            this.keepAlive(prototype.keepAlive());
            this.reuseAddress(prototype.reuseAddress());
            this.tcpNoDelay(prototype.tcpNoDelay());
            this.addSocketOptions(prototype.socketOptions());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.readTimeout(builder.readTimeout());
            this.connectTimeout(builder.connectTimeout());
            this.sendBufferSize(builder.sendBufferSize());
            this.receiveBufferSize(builder.receiveBufferSize());
            this.keepAlive(builder.keepAlive());
            this.reuseAddress(builder.reuseAddress());
            this.tcpNoDelay(builder.tcpNoDelay());
            this.addSocketOptions(builder.socketOptions());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("read-timeout").as(Duration.class).ifPresent(this::readTimeout);
            config.get("connect-timeout").as(Duration.class).ifPresent(this::connectTimeout);
            config.get("send-buffer-size").as(Integer.class).ifPresent(this::sendBufferSize);
            config.get("receive-buffer-size").as(Integer.class).ifPresent(this::receiveBufferSize);
            config.get("keep-alive").as(Boolean.class).ifPresent(this::keepAlive);
            config.get("reuse-address").as(Boolean.class).ifPresent(this::reuseAddress);
            config.get("tcp-no-delay").as(Boolean.class).ifPresent(this::tcpNoDelay);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readTimeout(Duration readTimeout) {
            Objects.requireNonNull(readTimeout);
            this.readTimeout = readTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectTimeout(Duration connectTimeout) {
            Objects.requireNonNull(connectTimeout);
            this.connectTimeout = connectTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER reuseAddress(boolean reuseAddress) {
            this.reuseAddress = reuseAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(Map<SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.clear();
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocketOptions(Map<SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putSocketOption(SocketOption<?> key, Object socketOption) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(socketOption);
            this.socketOptions.put(key, socketOption);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Duration readTimeout() {
            return this.readTimeout;
        }

        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        public int sendBufferSize() {
            return this.sendBufferSize;
        }

        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        public boolean keepAlive() {
            return this.keepAlive;
        }

        public boolean reuseAddress() {
            return this.reuseAddress;
        }

        public boolean tcpNoDelay() {
            return this.tcpNoDelay;
        }

        public Map<SocketOption<?>, Object> socketOptions() {
            return this.socketOptions;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ConnectionConfigBuilder{readTimeout=" + String.valueOf(this.readTimeout) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",sendBufferSize=" + this.sendBufferSize + ",receiveBufferSize=" + this.receiveBufferSize + ",keepAlive=" + this.keepAlive + ",reuseAddress=" + this.reuseAddress + ",tcpNoDelay=" + this.tcpNoDelay + ",socketOptions=" + String.valueOf(this.socketOptions) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class ConnectionConfigImpl
        implements ConnectionConfig {
            private final boolean keepAlive;
            private final boolean reuseAddress;
            private final boolean tcpNoDelay;
            private final Duration connectTimeout;
            private final Duration readTimeout;
            private final int receiveBufferSize;
            private final int sendBufferSize;
            private final Map<SocketOption<?>, Object> socketOptions;

            protected ConnectionConfigImpl(BuilderBase<?, ?> builder) {
                this.readTimeout = builder.readTimeout();
                this.connectTimeout = builder.connectTimeout();
                this.sendBufferSize = builder.sendBufferSize();
                this.receiveBufferSize = builder.receiveBufferSize();
                this.keepAlive = builder.keepAlive();
                this.reuseAddress = builder.reuseAddress();
                this.tcpNoDelay = builder.tcpNoDelay();
                this.socketOptions = Collections.unmodifiableMap(new LinkedHashMap(builder.socketOptions()));
            }

            @Override
            public Duration readTimeout() {
                return this.readTimeout;
            }

            @Override
            public Duration connectTimeout() {
                return this.connectTimeout;
            }

            @Override
            public int sendBufferSize() {
                return this.sendBufferSize;
            }

            @Override
            public int receiveBufferSize() {
                return this.receiveBufferSize;
            }

            @Override
            public boolean keepAlive() {
                return this.keepAlive;
            }

            @Override
            public boolean reuseAddress() {
                return this.reuseAddress;
            }

            @Override
            public boolean tcpNoDelay() {
                return this.tcpNoDelay;
            }

            @Override
            public Map<SocketOption<?>, Object> socketOptions() {
                return this.socketOptions;
            }

            public String toString() {
                return "ConnectionConfig{readTimeout=" + String.valueOf(this.readTimeout) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",sendBufferSize=" + this.sendBufferSize + ",receiveBufferSize=" + this.receiveBufferSize + ",keepAlive=" + this.keepAlive + ",reuseAddress=" + this.reuseAddress + ",tcpNoDelay=" + this.tcpNoDelay + ",socketOptions=" + String.valueOf(this.socketOptions) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ConnectionConfig)) {
                    return false;
                }
                ConnectionConfig other = (ConnectionConfig)o;
                return Objects.equals(this.readTimeout, other.readTimeout()) && Objects.equals(this.connectTimeout, other.connectTimeout()) && this.sendBufferSize == other.sendBufferSize() && this.receiveBufferSize == other.receiveBufferSize() && this.keepAlive == other.keepAlive() && this.reuseAddress == other.reuseAddress() && this.tcpNoDelay == other.tcpNoDelay() && Objects.equals(this.socketOptions, other.socketOptions());
            }

            public int hashCode() {
                return Objects.hash(this.readTimeout, this.connectTimeout, this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.socketOptions);
            }
        }
    }
}

