/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public enum SubscriptionHelper implements Flow.Subscription
{
    CANCELED,
    BAD_REQUEST;


    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
    }

    public static long addRequest(AtomicLong field, long n) {
        long update;
        long current;
        do {
            if ((current = field.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current + n;
            if (update >= 0L) continue;
            update = Long.MAX_VALUE;
        } while (!field.compareAndSet(current, update));
        return current;
    }

    public static long produced(AtomicLong field, long n) {
        long update;
        long current;
        do {
            if ((current = field.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            throw new IllegalStateException("More produced than requested: " + update);
        } while (!field.compareAndSet(current, update));
        return update;
    }

    public static boolean setOnce(AtomicReference<Flow.Subscription> subscriptionField, Flow.Subscription upstream) {
        Objects.requireNonNull(upstream);
        do {
            Flow.Subscription current;
            if ((current = subscriptionField.get()) == CANCELED) {
                upstream.cancel();
                return false;
            }
            if (current == BAD_REQUEST) {
                return true;
            }
            if (current == null) continue;
            upstream.cancel();
            throw new IllegalStateException("Flow.Subscription already set.");
        } while (!subscriptionField.compareAndSet(null, upstream));
        return true;
    }

    public static boolean deferredSetOnce(AtomicReference<Flow.Subscription> subscriptionField, AtomicLong requestedField, Flow.Subscription upstream) {
        if (SubscriptionHelper.setOnce(subscriptionField, upstream)) {
            long requested = requestedField.getAndSet(0L);
            if (requested != 0L) {
                upstream.request(requested);
            }
            return true;
        }
        return false;
    }

    public static void deferredRequest(AtomicReference<Flow.Subscription> subscriptionField, AtomicLong requestedField, long n) {
        Flow.Subscription subscription = subscriptionField.get();
        if (subscription != null) {
            subscription.request(n);
        } else {
            long toRequest;
            SubscriptionHelper.addRequest(requestedField, n);
            subscription = subscriptionField.get();
            if (subscription != null && (toRequest = requestedField.getAndSet(0L)) != 0L) {
                subscription.request(toRequest);
            }
        }
    }

    public static boolean cancel(AtomicReference<Flow.Subscription> subscriptionField) {
        Flow.Subscription subscription = subscriptionField.get();
        if (subscription != CANCELED && (subscription = subscriptionField.getAndSet(CANCELED)) != CANCELED) {
            if (subscription != null) {
                subscription.cancel();
            }
            return true;
        }
        return false;
    }

    public static boolean badRequest(AtomicReference<Flow.Subscription> subscriptionField) {
        return subscriptionField.compareAndSet(null, BAD_REQUEST);
    }

    public static void validate(Flow.Subscription current, Flow.Subscription incoming) {
        Objects.requireNonNull(incoming);
        if (current != null) {
            incoming.cancel();
            throw new IllegalStateException("Flow.Subscription already set.");
        }
    }

    public static void replace(AtomicReference<Flow.Subscription> field, Flow.Subscription incoming) {
        Flow.Subscription current;
        do {
            if ((current = field.get()) != CANCELED) continue;
            if (incoming != null) {
                incoming.cancel();
            }
            return;
        } while (!field.compareAndSet(current, incoming));
    }
}

