/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

class SingleDeferredSubscription<T>
extends AtomicInteger
implements Flow.Subscription {
    private final Supplier<? extends T> value;
    private final Flow.Subscriber<? super T> subscriber;
    static final int FRESH = 0;
    static final int REQUESTED = 1;
    static final int COMPLETED = 2;
    static final int CANCELED = 3;
    static final int ERRORED = 4;

    SingleDeferredSubscription(Supplier<? extends T> valueSupplier, Flow.Subscriber<? super T> subscriber) {
        super(0);
        this.value = valueSupplier;
        this.subscriber = subscriber;
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.subscriber.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden."));
        } else if (this.compareAndSet(0, 1)) {
            try {
                this.subscriber.onNext(this.value.get());
            }
            catch (Throwable t) {
                this.set(4);
                this.subscriber.onError(t);
            }
            if (this.compareAndSet(1, 2)) {
                this.subscriber.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        this.set(3);
    }
}

