/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SingleDeferredSubscription;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

final class SingleDeferredDefaultIfEmpty<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Supplier<? extends T> defaultItem;

    SingleDeferredDefaultIfEmpty(Single<T> source, Supplier<? extends T> defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(subscriber, this.defaultItem));
    }

    static final class DefaultIfEmptySubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Supplier<? extends T> defaultItemSupplier;
        private final AtomicLong requested;
        private final AtomicReference<Flow.Subscription> fallback;
        private Flow.Subscription upstream;

        DefaultIfEmptySubscriber(Flow.Subscriber<? super T> downstream, Supplier<? extends T> defaultItem) {
            this.downstream = downstream;
            this.defaultItemSupplier = defaultItem;
            this.requested = new AtomicLong();
            this.fallback = new AtomicReference();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.upstream == SubscriptionHelper.CANCELED) {
                this.downstream.onComplete();
            } else {
                SubscriptionHelper.deferredSetOnce(this.fallback, this.requested, new SingleDeferredSubscription<T>(this.defaultItemSupplier, this.downstream));
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
            SubscriptionHelper.deferredRequest(this.fallback, this.requested, n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallback);
        }
    }
}

