/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Supplier;

final class MultiReduceFull<T, R>
extends CompletionSingle<R> {
    private final Multi<T> source;
    private final Supplier<? extends R> supplier;
    private final BiFunction<R, T, R> reducer;

    MultiReduceFull(Multi<T> source, Supplier<? extends R> supplier, BiFunction<R, T, R> reducer) {
        this.source = source;
        this.supplier = supplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        R initial;
        try {
            initial = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null item");
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        this.source.subscribe(new ReduceFullSubscriber<T, R>(subscriber, initial, this.reducer));
    }

    static final class ReduceFullSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Flow.Subscriber<T> {
        private final BiFunction<R, T, R> reducer;
        private R accumulator;
        private Flow.Subscription upstream;

        ReduceFullSubscriber(Flow.Subscriber<? super R> downstream, R initial, BiFunction<R, T, R> reducer) {
            super(downstream);
            this.reducer = reducer;
            this.accumulator = initial;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                try {
                    this.accumulator = Objects.requireNonNull(this.reducer.apply(this.accumulator, item), "The reducer returned a null item");
                }
                catch (Throwable ex) {
                    s.cancel();
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.accumulator = null;
                this.error(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                R accumulator = this.accumulator;
                this.accumulator = null;
                this.complete(accumulator);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

