/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.DeferredSubscription;
import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiFromInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntSupplier;

class MultiFromBlockingInputStream
extends MultiFromInputStream {
    private final InputStream inputStream;
    private IntSupplier bufferSizeSupplier;
    private final ExecutorService executorService;

    MultiFromBlockingInputStream(InputStream inputStream, int bufferSize, ExecutorService executorService) {
        super(inputStream, bufferSize);
        this.inputStream = inputStream;
        this.bufferSizeSupplier = () -> bufferSize;
        this.executorService = executorService;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            this.inputStream.available();
        }
        catch (IOException e) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(e);
            return;
        }
        InputStreamSubscription subscription = new InputStreamSubscription(subscriber, this.inputStream, this.bufferSizeSupplier.getAsInt(), this.executorService);
        DeferredSubscription ds = new DeferredSubscription();
        subscriber.onSubscribe(ds);
        ds.setSubscription(subscription);
    }

    @Override
    public Multi<ByteBuffer> withByteBufferSize(int bufferSize) {
        this.bufferSizeSupplier = () -> bufferSize;
        return this;
    }

    static final class InputStreamSubscription
    extends MultiFromInputStream.InputStreamSubscription {
        private final ExecutorService executorService;
        private Lock lck = new ReentrantLock();

        InputStreamSubscription(Flow.Subscriber<? super ByteBuffer> downstream, InputStream inputStream, int bufferSize, ExecutorService executorService) {
            super(downstream, inputStream, bufferSize);
            this.executorService = executorService;
        }

        @Override
        protected void trySubmit(long n) {
            this.executorService.submit(() -> {
                try {
                    this.lck.lock();
                    this.submit(n);
                }
                finally {
                    this.lck.unlock();
                }
            });
        }
    }
}

