/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Awaitable<T> {
    public CompletableFuture<T> toCompletableFuture();

    default public T await() {
        return this.toCompletableFuture().join();
    }

    default public T await(long timeout, TimeUnit unit) {
        try {
            return this.toCompletableFuture().get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new CompletionException(e);
        }
    }

    default public T await(Duration duration) {
        try {
            return this.toCompletableFuture().get(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new CompletionException(e);
        }
    }
}

