/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SimpleXMLParser {
    private static final String PROLOG_START = "<?xml";
    private static final String PROLOG_END = "?>";
    private static final String PI_START = "<?";
    private static final String PI_END = "?>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String ELEMENT_SELF_CLOSE = "/>";
    private static final String CLOSE_MARKUP_START = "</";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final char MARKUP_START = '<';
    private static final char MARKUP_END = '>';
    private static final char ATTRIBUTE_VALUE = '=';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char[] ALLOWED_CHARS = new char[]{'_', '.', '-', ':'};
    private final char[] buf = new char[1024];
    private char c;
    private int position;
    private int lastPosition;
    private int limit = 0;
    private int lineNo = 1;
    private int charNo = 0;
    private StringBuilder nameBuilder = new StringBuilder();
    private StringBuilder textBuilder = new StringBuilder();
    private StringBuilder attrNameBuilder = new StringBuilder();
    private StringBuilder attrValueBuilder = new StringBuilder();
    private Map<String, String> attributes = new HashMap<String, String>();
    private STATE state = STATE.START;
    private STATE resumeState = null;
    private final LinkedList<String> stack = new LinkedList();
    private final Reader reader;
    private final InputStreamReader isr;

    SimpleXMLParser(InputStream is, Reader reader) {
        this.isr = new InputStreamReader(Objects.requireNonNull(is, "input stream is null"));
        this.reader = Objects.requireNonNull(reader, "reader is null");
    }

    public static void parse(InputStream is, Reader reader) throws IOException {
        new SimpleXMLParser(is, reader).parse();
    }

    public static SimpleXMLParser create(InputStream is, Reader reader) {
        return new SimpleXMLParser(is, reader);
    }

    public static String processXmlEscapes(String input) {
        return input.replaceAll("&quot;", "\"").replaceAll("&apos", "'").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
    }

    public int lineNumber() {
        return this.lineNo;
    }

    public int charNumber() {
        return this.charNo;
    }

    private void processStart() throws IOException {
        if (this.hasToken(PROLOG_START)) {
            this.state = STATE.PROLOG;
            this.position += PROLOG_START.length();
        } else if (this.hasToken('<')) {
            this.state = STATE.ELEMENT;
        } else {
            ++this.position;
        }
    }

    private void processProlog() throws IOException {
        if (this.hasToken("?>")) {
            this.state = STATE.ELEMENT;
            this.position += "?>".length();
        } else {
            ++this.position;
        }
    }

    private void processElement() throws IOException {
        if (this.hasToken(CDATA_START)) {
            this.state = STATE.CDATA;
            this.resumeState = STATE.ELEMENT;
            this.position += CDATA_START.length();
        } else if (this.hasToken(CDATA_END)) {
            this.state = STATE.END_ELEMENT;
            this.position += CDATA_END.length();
        } else if (this.hasToken(COMMENT_START)) {
            this.state = STATE.COMMENT;
            this.resumeState = STATE.ELEMENT;
            this.position += COMMENT_START.length();
        } else if (this.hasToken(CLOSE_MARKUP_START)) {
            this.state = STATE.END_ELEMENT;
            ++this.position;
        } else if (this.hasToken(PI_START)) {
            this.resumeState = STATE.PI_CONTENT;
            this.state = STATE.PI_TARGET;
            this.position += PI_START.length();
        } else if (this.hasToken("?>")) {
            this.state = STATE.END_ELEMENT;
            this.position += "?>".length();
        } else if (this.hasToken('<')) {
            this.resumeState = STATE.ATTRIBUTES;
            this.state = STATE.NAME;
            ++this.position;
        } else if (Character.isWhitespace(this.c)) {
            ++this.position;
        } else {
            this.state = STATE.TEXT;
            this.textBuilder.append(this.c);
            ++this.position;
        }
    }

    private void processName() throws IOException {
        if (this.hasToken('>') || this.hasToken(ELEMENT_SELF_CLOSE)) {
            this.state = this.resumeState;
        } else if (Character.isWhitespace(this.c)) {
            ++this.position;
            this.state = this.resumeState;
        } else {
            this.validateNameChar(this.c, this.nameBuilder.length() == 0);
            ++this.position;
            this.nameBuilder.append(this.c);
        }
    }

    private void processEndElement() {
        if (Character.isWhitespace(this.c)) {
            ++this.position;
        } else if (this.hasToken('>')) {
            String name = this.nameBuilder.toString();
            if (this.stack.isEmpty()) {
                throw new IllegalStateException(String.format("Missing opening element: %s", name));
            }
            String parentName = this.stack.pop();
            if (!name.equals(parentName)) {
                throw new IllegalStateException(String.format("Invalid closing element: %s, expecting: %s, line: %d, char: %d", name, parentName, this.lineNo, this.charNo));
            }
            ++this.position;
            this.state = STATE.ELEMENT;
            this.reader.elementText(SimpleXMLParser.decode(this.textBuilder.toString()));
            this.reader.endElement(name);
            this.nameBuilder = new StringBuilder();
            this.textBuilder = new StringBuilder();
        } else {
            this.resumeState = STATE.END_ELEMENT;
            this.state = STATE.NAME;
            ++this.position;
        }
    }

    private void processAttributes() throws IOException {
        if (Character.isWhitespace(this.c)) {
            ++this.position;
        } else if (this.hasToken(ELEMENT_SELF_CLOSE)) {
            this.position += ELEMENT_SELF_CLOSE.length();
            this.state = STATE.ELEMENT;
            String name = this.nameBuilder.toString();
            this.reader.startElement(name, this.attributes);
            this.reader.endElement(name);
            this.nameBuilder = new StringBuilder();
            this.attributes = new HashMap<String, String>();
        } else if (this.hasToken('>')) {
            ++this.position;
            this.state = STATE.ELEMENT;
            String name = this.nameBuilder.toString();
            this.stack.push(name);
            this.reader.startElement(name, this.attributes);
            this.nameBuilder = new StringBuilder();
            this.attributes = new HashMap<String, String>();
        } else if (this.hasToken('=')) {
            ++this.position;
            this.state = STATE.ATTRIBUTE_VALUE;
        } else {
            ++this.position;
            this.validateNameChar(this.c, this.attrNameBuilder.length() == 0);
            this.attrNameBuilder.append(this.c);
        }
    }

    private void processAttributeValue() {
        if (Character.isWhitespace(this.c)) {
            ++this.position;
        } else if (this.hasToken('\'')) {
            ++this.position;
            this.state = STATE.SINGLE_QUOTED_VALUE;
        } else if (this.hasToken('\"')) {
            ++this.position;
            this.state = STATE.DOUBLE_QUOTED_VALUE;
        } else {
            throw new IllegalStateException(String.format("Invalid state, line: %d, char: %d", this.lineNo, this.charNo));
        }
    }

    private void processQuoteValue(char token) {
        if (this.hasToken(token)) {
            ++this.position;
            this.state = STATE.ATTRIBUTES;
            this.attributes.put(this.attrNameBuilder.toString(), SimpleXMLParser.decode(this.attrValueBuilder.toString()));
            this.attrNameBuilder = new StringBuilder();
            this.attrValueBuilder = new StringBuilder();
        } else {
            this.validateAttrValueChar(this.c);
            ++this.position;
            this.attrValueBuilder.append(this.c);
        }
    }

    private void processText() throws IOException {
        if (this.hasToken(COMMENT_START)) {
            this.state = STATE.COMMENT;
            this.resumeState = STATE.TEXT;
            this.position += COMMENT_START.length();
        } else if (this.hasToken('<')) {
            this.state = STATE.ELEMENT;
        } else {
            this.textBuilder.append(this.buf[this.position]);
            ++this.position;
        }
    }

    private void processComment() throws IOException {
        if (this.hasToken(COMMENT_END)) {
            this.state = this.resumeState;
            this.position += COMMENT_END.length();
        } else {
            ++this.position;
        }
    }

    private void processCdata() throws IOException {
        if (this.hasToken(CDATA_END)) {
            this.state = this.resumeState;
            this.position += CDATA_END.length();
        } else {
            this.textBuilder.append(this.buf[this.position]);
            ++this.position;
        }
    }

    private void processPIContent() throws IOException {
        if (this.hasToken("?>")) {
            this.position += "?>".length();
            this.state = STATE.ELEMENT;
            String target = this.nameBuilder.toString();
            this.reader.startElement(target, this.attributes);
            this.reader.processingInstruction(target, SimpleXMLParser.decode(this.textBuilder.toString()));
            this.reader.endElement(target);
            this.nameBuilder = new StringBuilder();
            this.textBuilder = new StringBuilder();
        } else {
            ++this.position;
            this.textBuilder.append(this.c);
        }
    }

    private void processPITarget() throws IOException {
        if (this.hasToken("?>")) {
            this.state = this.resumeState;
        } else if (Character.isWhitespace(this.c)) {
            ++this.position;
            this.state = this.resumeState;
        } else {
            this.validateNameChar(this.c, this.nameBuilder.length() == 0);
            ++this.position;
            this.nameBuilder.append(this.c);
        }
    }

    public void parse() throws IOException {
        while (this.limit >= 0) {
            this.position = 0;
            this.limit = this.isr.read(this.buf);
            while (this.position < this.limit && this.reader.keepParsing()) {
                this.c = this.buf[this.position];
                if (this.c == '\n') {
                    ++this.lineNo;
                    this.charNo = 1;
                }
                this.lastPosition = this.position;
                switch (this.state) {
                    case START: {
                        this.processStart();
                        break;
                    }
                    case PROLOG: {
                        this.processProlog();
                        break;
                    }
                    case ELEMENT: {
                        this.processElement();
                        break;
                    }
                    case END_ELEMENT: {
                        this.processEndElement();
                        break;
                    }
                    case NAME: {
                        this.processName();
                        break;
                    }
                    case ATTRIBUTES: {
                        this.processAttributes();
                        break;
                    }
                    case ATTRIBUTE_VALUE: {
                        this.processAttributeValue();
                        break;
                    }
                    case SINGLE_QUOTED_VALUE: {
                        this.processQuoteValue('\'');
                        break;
                    }
                    case DOUBLE_QUOTED_VALUE: {
                        this.processQuoteValue('\"');
                        break;
                    }
                    case TEXT: {
                        this.processText();
                        break;
                    }
                    case COMMENT: {
                        this.processComment();
                        break;
                    }
                    case CDATA: {
                        this.processCdata();
                        break;
                    }
                    case PI_TARGET: {
                        this.processPITarget();
                        break;
                    }
                    case PI_CONTENT: {
                        this.processPIContent();
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unknown state: %s, line: %d, char: %d", new Object[]{this.state, this.lineNo, this.charNo}));
                    }
                }
                this.charNo += this.position - this.lastPosition;
            }
        }
        if (this.reader.keepParsing()) {
            if (!this.stack.isEmpty()) {
                throw new IllegalStateException(String.format("Unclosed element: %s", this.stack.peek()));
            }
            if (this.state != STATE.ELEMENT) {
                throw new IllegalStateException(String.format("Invalid state: %s", new Object[]{this.state}));
            }
        }
    }

    private void validateAttrValueChar(char c) {
        if (c == '<' || c == '>') {
            throw new IllegalStateException(String.format("Invalid character found in value: '%c', line: %d, char: %d", Character.valueOf(c), this.lineNo, this.charNo));
        }
    }

    private void validateNameChar(char c, boolean firstChar) {
        if (firstChar && !Character.isLetter(c) && c != '_' || !SimpleXMLParser.isAllowedChar(c)) {
            throw new IllegalStateException(String.format("Invalid character found in name: '%c', line: %d, char: %d", Character.valueOf(c), this.lineNo, this.charNo));
        }
    }

    boolean hasToken(char expected) {
        return this.position < this.limit && this.buf[this.position] == expected;
    }

    boolean hasToken(CharSequence expected) throws IOException {
        int len = expected.length();
        if (this.position + len > this.limit) {
            int offset = this.limit - this.position;
            System.arraycopy(this.buf, this.position, this.buf, 0, offset);
            int read = this.isr.read(this.buf, offset, this.buf.length - offset);
            this.limit = offset + (read == -1 ? 0 : read);
            this.position = 0;
            this.lastPosition = 0;
        }
        return String.valueOf(this.buf, this.position, expected.length()).contentEquals(expected);
    }

    private static String decode(String value) {
        return value.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&").replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
    }

    private static boolean isAllowedChar(char c) {
        if (Character.isLetter(c) || Character.isDigit(c)) {
            return true;
        }
        for (char a : ALLOWED_CHARS) {
            if (a != c) continue;
            return true;
        }
        return false;
    }

    private static enum STATE {
        START,
        PROLOG,
        COMMENT,
        CDATA,
        ELEMENT,
        END_ELEMENT,
        NAME,
        TEXT,
        ATTRIBUTES,
        ATTRIBUTE_VALUE,
        SINGLE_QUOTED_VALUE,
        DOUBLE_QUOTED_VALUE,
        PI_TARGET,
        PI_CONTENT;

    }

    public static interface Reader {
        default public void startElement(String name, Map<String, String> attributes) {
        }

        default public void endElement(String name) {
        }

        default public void elementText(String data) {
        }

        default public boolean keepParsing() {
            return true;
        }

        default public void validateChild(String child, String parent, String qName) throws XMLReaderException {
            if (!child.equals(qName)) {
                throw new XMLReaderException(String.format("Invalid child for '%s', node: '%s'", parent, qName));
            }
        }

        default public String readAttribute(String name, String qName, Map<String, String> attr, String defaultValue) {
            String value = attr.get(name);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        default public String readRequiredAttribute(String name, String qName, Map<String, String> attr) throws XMLReaderException {
            String value = attr.get(name);
            if (value == null) {
                throw new XMLReaderException(String.format("Missing required attribute '%s', element: '%s'", name, qName));
            }
            return value;
        }

        default public List<String> readAttributeList(String name, String qName, Map<String, String> attr) {
            String value = attr.get(name);
            if (value == null) {
                return Collections.emptyList();
            }
            LinkedList<String> values = new LinkedList<String>();
            Collections.addAll(values, value.split(","));
            return values;
        }

        default public void processingInstruction(String target, String data) {
        }
    }

    public static class XMLReaderException
    extends XMLException {
        public XMLReaderException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public XMLReaderException(String msg) {
            super(msg);
        }

        public XMLReaderException() {
        }
    }

    public static class XMLParserException
    extends XMLException {
        public XMLParserException(String msg) {
            super(msg);
        }
    }

    public static class XMLException
    extends RuntimeException {
        protected XMLException(String msg, Throwable cause) {
            super(msg, cause);
        }

        protected XMLException(String msg) {
            super(msg);
        }

        protected XMLException() {
        }
    }
}

