/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Context;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.grpclb.BackendAddressGroup;
import io.grpc.grpclb.GrpclbClientLoadRecorder;
import io.grpc.grpclb.GrpclbConfig;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.grpclb.TokenAttachingTracerFactory;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.lb.v1.ClientStats;
import io.grpc.lb.v1.InitialLoadBalanceRequest;
import io.grpc.lb.v1.InitialLoadBalanceResponse;
import io.grpc.lb.v1.LoadBalanceRequest;
import io.grpc.lb.v1.LoadBalanceResponse;
import io.grpc.lb.v1.LoadBalancerGrpc;
import io.grpc.lb.v1.Server;
import io.grpc.lb.v1.ServerList;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class GrpclbState {
    static final long FALLBACK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Attributes LB_PROVIDED_BACKEND_ATTRS = Attributes.newBuilder().set(GrpclbConstants.ATTR_LB_PROVIDED_BACKEND, (Object)true).build();
    static final boolean SHOULD_LOG_SERVER_LISTS = Boolean.parseBoolean(System.getProperty("io.grpc.grpclb.LogServerLists", "true"));
    @VisibleForTesting
    static final LoadBalancer.PickResult DROP_PICK_RESULT = LoadBalancer.PickResult.withDrop((Status)Status.UNAVAILABLE.withDescription("Dropped as requested by balancer"));
    @VisibleForTesting
    static final Status NO_AVAILABLE_BACKENDS_STATUS = Status.UNAVAILABLE.withDescription("LoadBalancer responded without any backends");
    @VisibleForTesting
    static final Status BALANCER_TIMEOUT_STATUS = Status.UNAVAILABLE.withDescription("Timeout waiting for remote balancer");
    @VisibleForTesting
    static final Status BALANCER_REQUESTED_FALLBACK_STATUS = Status.UNAVAILABLE.withDescription("Fallback requested by balancer");
    @VisibleForTesting
    static final Status NO_FALLBACK_BACKENDS_STATUS = Status.UNAVAILABLE.withDescription("Unable to fallback, no fallback addresses found");
    private static final Status NO_LB_ADDRESS_PROVIDED_STATUS = Status.UNAVAILABLE.withDescription("No balancer address found");
    @VisibleForTesting
    static final RoundRobinEntry BUFFER_ENTRY = new RoundRobinEntry(){

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_ENTRY";
        }
    };
    @VisibleForTesting
    static final String NO_USE_AUTHORITY_SUFFIX = "-notIntendedToBeUsed";
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final Context context;
    private final SynchronizationContext syncContext;
    @Nullable
    private final SubchannelPool subchannelPool;
    private final TimeProvider time;
    private final Stopwatch stopwatch;
    private final ScheduledExecutorService timerService;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.create((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final ChannelLogger logger;
    @Nullable
    private SynchronizationContext.ScheduledHandle fallbackTimer;
    private List<EquivalentAddressGroup> fallbackBackendList = Collections.emptyList();
    private boolean usingFallbackBackends;
    @Nullable
    private Status fallbackReason;
    private boolean balancerWorking;
    @Nullable
    private BackoffPolicy lbRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lbRpcRetryTimer;
    @Nullable
    private ManagedChannel lbCommChannel;
    @Nullable
    private LbStream lbStream;
    private Map<List<EquivalentAddressGroup>, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private final GrpclbConfig config;
    private List<DropEntry> dropList = Collections.emptyList();
    private List<BackendEntry> backendList = Collections.emptyList();
    private RoundRobinPicker currentPicker = new RoundRobinPicker(Collections.emptyList(), Arrays.asList(BUFFER_ENTRY));
    private boolean requestConnectionPending;

    GrpclbState(GrpclbConfig config, LoadBalancer.Helper helper, Context context, SubchannelPool subchannelPool, TimeProvider time, Stopwatch stopwatch, BackoffPolicy.Provider backoffPolicyProvider) {
        this.config = (GrpclbConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        if (config.getMode() == Mode.ROUND_ROBIN) {
            this.subchannelPool = (SubchannelPool)Preconditions.checkNotNull((Object)subchannelPool, (Object)"subchannelPool");
            subchannelPool.registerListener(new SubchannelPool.PooledSubchannelStateListener(){

                @Override
                public void onSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
                    GrpclbState.this.handleSubchannelState(subchannel, newState);
                }
            });
        } else {
            this.subchannelPool = null;
        }
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
        this.stopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch, (Object)"stopwatch");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timerService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.serviceName = config.getServiceName() != null ? config.getServiceName() : (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.logger = (ChannelLogger)Preconditions.checkNotNull((Object)helper.getChannelLogger(), (Object)"logger");
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "[grpclb-<{0}>] Created", new Object[]{this.serviceName});
    }

    void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        boolean keepState;
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.containsValue(subchannel)) {
            return;
        }
        if (this.config.getMode() == Mode.ROUND_ROBIN && newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        if (newState.getState() == ConnectivityState.TRANSIENT_FAILURE || newState.getState() == ConnectivityState.IDLE) {
            this.helper.refreshNameResolution();
        }
        AtomicReference stateInfoRef = (AtomicReference)subchannel.getAttributes().get(STATE_INFO);
        boolean bl = keepState = this.config.getMode() == Mode.ROUND_ROBIN && ((ConnectivityStateInfo)stateInfoRef.get()).getState() == ConnectivityState.TRANSIENT_FAILURE && (newState.getState() == ConnectivityState.CONNECTING || newState.getState() == ConnectivityState.IDLE);
        if (!keepState) {
            stateInfoRef.set(newState);
            this.maybeUseFallbackBackends();
            this.maybeUpdatePicker();
        }
    }

    void handleAddresses(List<EquivalentAddressGroup> newLbAddressGroups, List<EquivalentAddressGroup> newBackendServers) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Resolved addresses: lb addresses {0}, backends: {1}", new Object[]{this.serviceName, newLbAddressGroups, newBackendServers});
        this.fallbackBackendList = newBackendServers;
        if (newLbAddressGroups.isEmpty()) {
            this.shutdownLbComm();
            if (!this.usingFallbackBackends) {
                this.fallbackReason = NO_LB_ADDRESS_PROVIDED_STATUS;
                this.cancelFallbackTimer();
                this.maybeUseFallbackBackends();
            }
        } else {
            this.startLbComm(newLbAddressGroups);
            if (this.lbStream == null) {
                this.cancelLbRpcRetryTimer();
                this.startLbRpc();
            }
            if (this.fallbackTimer == null && !this.usingFallbackBackends) {
                this.fallbackTimer = this.syncContext.schedule((Runnable)new FallbackModeTask(BALANCER_TIMEOUT_STATUS), FALLBACK_TIMEOUT_MS, TimeUnit.MILLISECONDS, this.timerService);
            }
        }
        if (this.usingFallbackBackends) {
            this.useFallbackBackends();
        }
        this.maybeUpdatePicker();
    }

    void requestConnection() {
        this.requestConnectionPending = true;
        for (RoundRobinEntry roundRobinEntry : this.currentPicker.pickList) {
            if (!(roundRobinEntry instanceof IdleSubchannelEntry)) continue;
            ((IdleSubchannelEntry)roundRobinEntry).subchannel.requestConnection();
            this.requestConnectionPending = false;
        }
    }

    private void maybeUseFallbackBackends() {
        if (this.balancerWorking || this.usingFallbackBackends) {
            return;
        }
        Preconditions.checkState((this.fallbackReason != null ? 1 : 0) != 0, (Object)"no reason to fallback");
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).get();
            if (stateInfo.getState() == ConnectivityState.READY) {
                return;
            }
            if (stateInfo.getState() != ConnectivityState.TRANSIENT_FAILURE) continue;
            this.fallbackReason = stateInfo.getStatus();
        }
        this.useFallbackBackends();
    }

    private void useFallbackBackends() {
        this.usingFallbackBackends = true;
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "[grpclb-<{0}>] Using fallback backends", new Object[]{this.serviceName});
        ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
        ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
        for (EquivalentAddressGroup eag : this.fallbackBackendList) {
            newDropList.add(null);
            newBackendAddrList.add(new BackendAddressGroup(eag, null));
        }
        this.updateServerList(newDropList, newBackendAddrList, null);
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        this.shutdownLbRpc();
    }

    private void shutdownLbRpc() {
        if (this.lbStream != null) {
            this.lbStream.close((Exception)Status.CANCELLED.withDescription("balancer shutdown").asException());
        }
    }

    private void startLbComm(List<EquivalentAddressGroup> overrideAuthorityEags) {
        Preconditions.checkNotNull(overrideAuthorityEags, (Object)"overrideAuthorityEags");
        assert (!overrideAuthorityEags.isEmpty());
        String doNotUseAuthority = (String)overrideAuthorityEags.get(0).getAttributes().get(EquivalentAddressGroup.ATTR_AUTHORITY_OVERRIDE) + NO_USE_AUTHORITY_SUFFIX;
        if (this.lbCommChannel == null) {
            this.lbCommChannel = this.helper.createOobChannel(overrideAuthorityEags, doNotUseAuthority);
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Created grpclb channel: EAG={1}", new Object[]{this.serviceName, overrideAuthorityEags});
        } else {
            this.helper.updateOobChannelAddresses(this.lbCommChannel, overrideAuthorityEags);
        }
    }

    private void startLbRpc() {
        Preconditions.checkState((this.lbStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbStream = new LbStream(stub);
        Context prevContext = this.context.attach();
        try {
            this.lbStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
        this.stopwatch.reset().start();
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Sent initial grpclb request {1}", new Object[]{this.serviceName, initRequest});
        try {
            this.lbStream.lbRequestWriter.onNext((Object)initRequest);
        }
        catch (Exception e) {
            this.lbStream.close(e);
        }
    }

    private void cancelFallbackTimer() {
        if (this.fallbackTimer != null) {
            this.fallbackTimer.cancel();
        }
    }

    private void cancelLbRpcRetryTimer() {
        if (this.lbRpcRetryTimer != null) {
            this.lbRpcRetryTimer.cancel();
            this.lbRpcRetryTimer = null;
        }
    }

    void shutdown() {
        this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "[grpclb-<{0}>] Shutdown", new Object[]{this.serviceName});
        this.shutdownLbComm();
        switch (this.config.getMode()) {
            case ROUND_ROBIN: {
                for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
                    this.returnSubchannelToPool(subchannel);
                }
                this.subchannelPool.clear();
                break;
            }
            case PICK_FIRST: {
                if (this.subchannels.isEmpty()) break;
                Preconditions.checkState((this.subchannels.size() == 1 ? 1 : 0) != 0, (String)"Excessive Subchannels: %s", this.subchannels);
                this.subchannels.values().iterator().next().shutdown();
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.config.getMode())));
            }
        }
        this.subchannels = Collections.emptyMap();
        this.cancelFallbackTimer();
        this.cancelLbRpcRetryTimer();
    }

    void propagateError(Status status) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Error: {1}", new Object[]{this.serviceName, status});
        if (this.backendList.isEmpty()) {
            Status error = Status.UNAVAILABLE.withCause(status.getCause()).withDescription(status.getDescription());
            this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new RoundRobinPicker(this.dropList, Arrays.asList(new ErrorEntry(error))));
        }
    }

    private void returnSubchannelToPool(LoadBalancer.Subchannel subchannel) {
        this.subchannelPool.returnSubchannel(subchannel, (ConnectivityStateInfo)((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).get());
    }

    @Nullable
    @VisibleForTesting
    GrpclbClientLoadRecorder getLoadRecorder() {
        if (this.lbStream == null) {
            return null;
        }
        return this.lbStream.loadRecorder;
    }

    private void updateServerList(List<DropEntry> newDropList, List<BackendAddressGroup> newBackendAddrList, @Nullable GrpclbClientLoadRecorder loadRecorder) {
        HashMap<List<EquivalentAddressGroup>, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<List<EquivalentAddressGroup>, LoadBalancer.Subchannel>();
        ArrayList<BackendEntry> newBackendList = new ArrayList<BackendEntry>();
        switch (this.config.getMode()) {
            case ROUND_ROBIN: {
                for (BackendAddressGroup backendAddressGroup : newBackendAddrList) {
                    EquivalentAddressGroup eag = backendAddressGroup.getAddresses();
                    List<EquivalentAddressGroup> eagAsList = Collections.singletonList(eag);
                    LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eagAsList);
                    if (subchannel == null) {
                        subchannel = this.subchannels.get(eagAsList);
                        if (subchannel == null) {
                            subchannel = this.subchannelPool.takeOrCreateSubchannel(eag, GrpclbState.createSubchannelAttrs());
                            subchannel.requestConnection();
                        }
                        newSubchannelMap.put(eagAsList, subchannel);
                    }
                    BackendEntry entry = backendAddressGroup.getToken() == null ? new BackendEntry(subchannel) : new BackendEntry(subchannel, loadRecorder, backendAddressGroup.getToken());
                    newBackendList.add(entry);
                }
                for (Map.Entry entry : this.subchannels.entrySet()) {
                    List eagList = (List)entry.getKey();
                    if (newSubchannelMap.containsKey(eagList)) continue;
                    this.returnSubchannelToPool((LoadBalancer.Subchannel)entry.getValue());
                }
                this.subchannels = Collections.unmodifiableMap(newSubchannelMap);
                break;
            }
            case PICK_FIRST: {
                LoadBalancer.Subchannel subchannel;
                Preconditions.checkState((this.subchannels.size() <= 1 ? 1 : 0) != 0, (String)"Unexpected Subchannel count: %s", this.subchannels);
                if (newBackendAddrList.isEmpty()) {
                    if (this.subchannels.size() != 1) break;
                    LoadBalancer.Subchannel subchannel2 = this.subchannels.values().iterator().next();
                    subchannel2.shutdown();
                    this.subchannels = Collections.emptyMap();
                    break;
                }
                ArrayList<EquivalentAddressGroup> arrayList = new ArrayList<EquivalentAddressGroup>();
                for (BackendAddressGroup bag : newBackendAddrList) {
                    EquivalentAddressGroup origEag = bag.getAddresses();
                    Attributes eagAttrs = origEag.getAttributes();
                    if (bag.getToken() != null) {
                        eagAttrs = eagAttrs.toBuilder().set(GrpclbConstants.TOKEN_ATTRIBUTE_KEY, (Object)bag.getToken()).build();
                    }
                    arrayList.add(new EquivalentAddressGroup(origEag.getAddresses(), eagAttrs));
                }
                if (this.subchannels.isEmpty()) {
                    subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(arrayList).setAttributes(GrpclbState.createSubchannelAttrs()).build());
                    subchannel.start(new LoadBalancer.SubchannelStateListener(){

                        public void onSubchannelState(ConnectivityStateInfo newState) {
                            GrpclbState.this.handleSubchannelState(subchannel, newState);
                        }
                    });
                    if (this.requestConnectionPending) {
                        subchannel.requestConnection();
                        this.requestConnectionPending = false;
                    }
                } else {
                    subchannel = this.subchannels.values().iterator().next();
                    subchannel.updateAddresses(arrayList);
                }
                this.subchannels = Collections.singletonMap(arrayList, subchannel);
                newBackendList.add(new BackendEntry(subchannel, new TokenAttachingTracerFactory((ClientStreamTracer.Factory)loadRecorder)));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.config.getMode())));
            }
        }
        this.dropList = Collections.unmodifiableList(newDropList);
        this.backendList = Collections.unmodifiableList(newBackendList);
    }

    private void maybeUpdatePicker() {
        ConnectivityState state;
        List<RoundRobinEntry> pickList;
        if (this.backendList.isEmpty()) {
            ConnectivityState state2;
            List<RoundRobinEntry> pickList2;
            if (this.usingFallbackBackends) {
                Status error = NO_FALLBACK_BACKENDS_STATUS.withCause(this.fallbackReason.getCause()).augmentDescription(this.fallbackReason.getDescription());
                pickList2 = Collections.singletonList(new ErrorEntry(error));
                state2 = ConnectivityState.TRANSIENT_FAILURE;
            } else if (this.balancerWorking) {
                pickList2 = Collections.singletonList(new ErrorEntry(NO_AVAILABLE_BACKENDS_STATUS));
                state2 = ConnectivityState.TRANSIENT_FAILURE;
            } else {
                pickList2 = Collections.singletonList(BUFFER_ENTRY);
                state2 = ConnectivityState.CONNECTING;
            }
            this.maybeUpdatePicker(state2, new RoundRobinPicker(this.dropList, pickList2));
            return;
        }
        block0 : switch (this.config.getMode()) {
            case ROUND_ROBIN: {
                pickList = new ArrayList<RoundRobinEntry>(this.backendList.size());
                Status error = null;
                boolean hasPending = false;
                for (BackendEntry entry : this.backendList) {
                    LoadBalancer.Subchannel subchannel = entry.subchannel;
                    Attributes attrs = subchannel.getAttributes();
                    ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
                    if (stateInfo.getState() == ConnectivityState.READY) {
                        pickList.add(entry);
                        continue;
                    }
                    if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE) {
                        error = stateInfo.getStatus();
                        continue;
                    }
                    hasPending = true;
                }
                if (pickList.isEmpty()) {
                    if (hasPending) {
                        pickList.add(BUFFER_ENTRY);
                        state = ConnectivityState.CONNECTING;
                        break;
                    }
                    pickList.add(new ErrorEntry(error));
                    state = ConnectivityState.TRANSIENT_FAILURE;
                    break;
                }
                state = ConnectivityState.READY;
                break;
            }
            case PICK_FIRST: {
                Preconditions.checkState((this.backendList.size() == 1 ? 1 : 0) != 0, (String)"Excessive backend entries: %s", this.backendList);
                BackendEntry onlyEntry = this.backendList.get(0);
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)onlyEntry.subchannel.getAttributes().get(STATE_INFO)).get();
                state = stateInfo.getState();
                switch (state) {
                    case READY: {
                        pickList = Collections.singletonList(onlyEntry);
                        break block0;
                    }
                    case TRANSIENT_FAILURE: {
                        pickList = Collections.singletonList(new ErrorEntry(stateInfo.getStatus()));
                        break block0;
                    }
                    case CONNECTING: {
                        pickList = Collections.singletonList(BUFFER_ENTRY);
                        break block0;
                    }
                }
                pickList = Collections.singletonList(new IdleSubchannelEntry(onlyEntry.subchannel, this.syncContext));
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing case for " + (Object)((Object)this.config.getMode())));
            }
        }
        this.maybeUpdatePicker(state, new RoundRobinPicker(this.dropList, pickList));
    }

    private void maybeUpdatePicker(ConnectivityState state, RoundRobinPicker picker) {
        if (picker.dropList.equals(this.currentPicker.dropList) && picker.pickList.equals(this.currentPicker.pickList)) {
            return;
        }
        this.currentPicker = picker;
        this.helper.updateBalancingState(state, (LoadBalancer.SubchannelPicker)picker);
    }

    private static Attributes createSubchannelAttrs() {
        return Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        @VisibleForTesting
        final List<DropEntry> dropList;
        private int dropIndex;
        @VisibleForTesting
        final List<? extends RoundRobinEntry> pickList;
        private int pickIndex;

        RoundRobinPicker(List<DropEntry> dropList, List<? extends RoundRobinEntry> pickList) {
            this.dropList = (List)Preconditions.checkNotNull(dropList, (Object)"dropList");
            this.pickList = (List)Preconditions.checkNotNull(pickList, (Object)"pickList");
            Preconditions.checkArgument((!pickList.isEmpty() ? 1 : 0) != 0, (Object)"pickList is empty");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<? extends RoundRobinEntry> list = this.pickList;
            synchronized (list) {
                if (!this.dropList.isEmpty()) {
                    DropEntry drop = this.dropList.get(this.dropIndex);
                    ++this.dropIndex;
                    if (this.dropIndex == this.dropList.size()) {
                        this.dropIndex = 0;
                    }
                    if (drop != null) {
                        return drop.picked();
                    }
                }
                RoundRobinEntry pick = this.pickList.get(this.pickIndex);
                ++this.pickIndex;
                if (this.pickIndex == this.pickList.size()) {
                    this.pickIndex = 0;
                }
                return pick.picked(args.getHeaders());
            }
        }

        public String toString() {
            if (SHOULD_LOG_SERVER_LISTS) {
                return MoreObjects.toStringHelper(RoundRobinPicker.class).add("dropList", this.dropList).add("pickList", this.pickList).toString();
            }
            return MoreObjects.toStringHelper(RoundRobinPicker.class).toString();
        }
    }

    @VisibleForTesting
    static final class ErrorEntry
    implements RoundRobinEntry {
        final LoadBalancer.PickResult result;

        ErrorEntry(Status status) {
            this.result = LoadBalancer.PickResult.withError((Status)status);
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            return this.result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result});
        }

        public boolean equals(Object other) {
            if (!(other instanceof ErrorEntry)) {
                return false;
            }
            return Objects.equal((Object)this.result, (Object)((ErrorEntry)other).result);
        }

        public String toString() {
            return this.result.getStatus().toString();
        }
    }

    @VisibleForTesting
    static final class IdleSubchannelEntry
    implements RoundRobinEntry {
        private final SynchronizationContext syncContext;
        private final LoadBalancer.Subchannel subchannel;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        IdleSubchannelEntry(LoadBalancer.Subchannel subchannel, SynchronizationContext syncContext) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
            this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        IdleSubchannelEntry.this.subchannel.requestConnection();
                    }
                });
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "(idle)[" + this.subchannel.getAllAddresses().toString() + "]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.subchannel, this.syncContext});
        }

        public boolean equals(Object other) {
            if (!(other instanceof IdleSubchannelEntry)) {
                return false;
            }
            IdleSubchannelEntry that = (IdleSubchannelEntry)other;
            return Objects.equal((Object)this.subchannel, (Object)that.subchannel) && Objects.equal((Object)this.syncContext, (Object)that.syncContext);
        }
    }

    @VisibleForTesting
    static final class BackendEntry
    implements RoundRobinEntry {
        final LoadBalancer.Subchannel subchannel;
        @VisibleForTesting
        final LoadBalancer.PickResult result;
        @Nullable
        private final String token;

        BackendEntry(LoadBalancer.Subchannel subchannel, GrpclbClientLoadRecorder loadRecorder, String token) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)((ClientStreamTracer.Factory)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder")));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        BackendEntry(LoadBalancer.Subchannel subchannel) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel);
            this.token = null;
        }

        BackendEntry(LoadBalancer.Subchannel subchannel, TokenAttachingTracerFactory tracerFactory) {
            this.subchannel = (LoadBalancer.Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
            this.result = LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)((ClientStreamTracer.Factory)Preconditions.checkNotNull((Object)((Object)tracerFactory), (Object)"tracerFactory")));
            this.token = null;
        }

        @Override
        public LoadBalancer.PickResult picked(Metadata headers) {
            headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
            if (this.token != null) {
                headers.put(GrpclbConstants.TOKEN_METADATA_KEY, (Object)this.token);
            }
            return this.result;
        }

        public String toString() {
            return "[" + this.subchannel.getAllAddresses().toString() + "(" + this.token + ")]";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof BackendEntry)) {
                return false;
            }
            BackendEntry that = (BackendEntry)other;
            return Objects.equal((Object)this.result, (Object)that.result) && Objects.equal((Object)this.token, (Object)that.token);
        }
    }

    @VisibleForTesting
    static interface RoundRobinEntry {
        public LoadBalancer.PickResult picked(Metadata var1);
    }

    @VisibleForTesting
    static final class DropEntry {
        private final GrpclbClientLoadRecorder loadRecorder;
        private final String token;

        DropEntry(GrpclbClientLoadRecorder loadRecorder, String token) {
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        LoadBalancer.PickResult picked() {
            this.loadRecorder.recordDroppedRequest(this.token);
            return DROP_PICK_RESULT;
        }

        public String toString() {
            return "drop(" + this.token + ")";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.loadRecorder, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof DropEntry)) {
                return false;
            }
            DropEntry that = (DropEntry)other;
            return Objects.equal((Object)((Object)this.loadRecorder), (Object)((Object)that.loadRecorder)) && Objects.equal((Object)this.token, (Object)that.token);
        }
    }

    private class LbStream
    implements StreamObserver<LoadBalanceResponse> {
        final GrpclbClientLoadRecorder loadRecorder;
        final LoadBalancerGrpc.LoadBalancerStub stub;
        StreamObserver<LoadBalanceRequest> lbRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalMillis = -1L;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        LbStream(LoadBalancerGrpc.LoadBalancerStub stub) {
            this.stub = (LoadBalancerGrpc.LoadBalancerStub)((Object)Preconditions.checkNotNull((Object)((Object)stub), (Object)"stub"));
            this.loadRecorder = new GrpclbClientLoadRecorder(GrpclbState.this.time);
        }

        void start() {
            this.lbRequestWriter = ((LoadBalancerGrpc.LoadBalancerStub)this.stub.withWaitForReady()).balanceLoad(this);
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable error) {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbState.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void sendLoadReport() {
            if (this.closed) {
                return;
            }
            ClientStats stats = this.loadRecorder.generateLoadReport();
            try {
                this.lbRequestWriter.onNext((Object)LoadBalanceRequest.newBuilder().setClientStats(stats).build());
                this.scheduleNextLoadReport();
            }
            catch (Exception e) {
                this.close(e);
            }
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportIntervalMillis > 0L) {
                this.loadReportTimer = GrpclbState.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.loadReportIntervalMillis, TimeUnit.MILLISECONDS, GrpclbState.this.timerService);
            }
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.closed) {
                return;
            }
            LoadBalanceResponse.LoadBalanceResponseTypeCase typeCase = response.getLoadBalanceResponseTypeCase();
            if (!this.initialResponseReceived) {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.INFO, "[grpclb-<{0}>] Got an LB initial response: {1}", new Object[]{GrpclbState.this.serviceName, response});
                if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.INITIAL_RESPONSE) {
                    GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "[grpclb-<{0}>] Received a response without initial response", new Object[]{GrpclbState.this.serviceName});
                    return;
                }
                this.initialResponseReceived = true;
                InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
                this.loadReportIntervalMillis = Durations.toMillis((Duration)initialResponse.getClientStatsReportInterval());
                this.scheduleNextLoadReport();
                return;
            }
            if (SHOULD_LOG_SERVER_LISTS) {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Got an LB response: {1}", new Object[]{GrpclbState.this.serviceName, response});
            } else {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "[grpclb-<{0}>] Got an LB response", new Object[]{GrpclbState.this.serviceName});
            }
            if (typeCase == LoadBalanceResponse.LoadBalanceResponseTypeCase.FALLBACK_RESPONSE) {
                GrpclbState.this.cancelFallbackTimer();
                GrpclbState.this.fallbackReason = BALANCER_REQUESTED_FALLBACK_STATUS;
                GrpclbState.this.useFallbackBackends();
                GrpclbState.this.maybeUpdatePicker();
                return;
            }
            if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.SERVER_LIST) {
                GrpclbState.this.logger.log(ChannelLogger.ChannelLogLevel.WARNING, "[grpclb-<{0}>] Ignoring unexpected response type: {1}", new Object[]{GrpclbState.this.serviceName, typeCase});
                return;
            }
            GrpclbState.this.balancerWorking = true;
            ServerList serverList = response.getServerList();
            ArrayList<DropEntry> newDropList = new ArrayList<DropEntry>();
            ArrayList<BackendAddressGroup> newBackendAddrList = new ArrayList<BackendAddressGroup>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                String token = server.getLoadBalanceToken();
                if (server.getDrop()) {
                    newDropList.add(new DropEntry(this.loadRecorder, token));
                    continue;
                }
                newDropList.add(null);
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbState.this.propagateError(Status.UNAVAILABLE.withDescription("Invalid backend address: " + server).withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address, LB_PROVIDED_BACKEND_ATTRS);
                newBackendAddrList.add(new BackendAddressGroup(eag, token));
            }
            GrpclbState.this.usingFallbackBackends = false;
            GrpclbState.this.fallbackReason = null;
            GrpclbState.this.cancelFallbackTimer();
            GrpclbState.this.updateServerList(newDropList, newBackendAddrList, this.loadRecorder);
            GrpclbState.this.maybeUpdatePicker();
        }

        private void handleStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            GrpclbState.this.propagateError(error);
            GrpclbState.this.balancerWorking = false;
            GrpclbState.this.fallbackReason = error;
            GrpclbState.this.cancelFallbackTimer();
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
            long delayNanos = 0L;
            if (this.initialResponseReceived || GrpclbState.this.lbRpcRetryPolicy == null) {
                GrpclbState.this.lbRpcRetryPolicy = GrpclbState.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = GrpclbState.this.lbRpcRetryPolicy.nextBackoffNanos() - GrpclbState.this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            if (delayNanos <= 0L) {
                GrpclbState.this.startLbRpc();
            } else {
                GrpclbState.this.lbRpcRetryTimer = GrpclbState.this.syncContext.schedule((Runnable)new LbRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, GrpclbState.this.timerService);
            }
            GrpclbState.this.helper.refreshNameResolution();
        }

        void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.lbRequestWriter.onError((Throwable)error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (GrpclbState.this.lbStream == this) {
                GrpclbState.this.lbStream = null;
            }
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LbStream stream;

        LoadReportingTask(LbStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.loadReportTimer = null;
            this.stream.sendLoadReport();
        }
    }

    @VisibleForTesting
    class LbRpcRetryTask
    implements Runnable {
        LbRpcRetryTask() {
        }

        @Override
        public void run() {
            GrpclbState.this.startLbRpc();
        }
    }

    @VisibleForTesting
    class FallbackModeTask
    implements Runnable {
        private final Status reason;

        private FallbackModeTask(Status reason) {
            this.reason = reason;
        }

        @Override
        public void run() {
            Preconditions.checkState((!GrpclbState.this.usingFallbackBackends ? 1 : 0) != 0, (Object)"already in fallback");
            GrpclbState.this.fallbackReason = this.reason;
            GrpclbState.this.maybeUseFallbackBackends();
            GrpclbState.this.maybeUpdatePicker();
        }
    }

    static enum Mode {
        ROUND_ROBIN,
        PICK_FIRST;

    }
}

