/*
 * Decompiled with CFR 0.152.
 */
package io.dgraph;

import io.dgraph.AsyncTransaction;
import io.dgraph.DgraphProto;
import io.dgraph.ExceptionUtil;
import java.util.Collections;
import java.util.Map;

public class Transaction
implements AutoCloseable {
    private final AsyncTransaction asyncTransaction;

    public Transaction(AsyncTransaction asyncTransaction) {
        this.asyncTransaction = asyncTransaction;
    }

    public DgraphProto.Response queryWithVars(String query, Map<String, String> vars) {
        return ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.queryWithVars(query, vars).join());
    }

    public DgraphProto.Response query(String query) {
        return this.queryWithVars(query, Collections.emptyMap());
    }

    public DgraphProto.Response queryRDFWithVars(String query, Map<String, String> vars) {
        return ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.queryRDFWithVars(query, vars).join());
    }

    public DgraphProto.Response queryRDF(String query) {
        return this.queryRDFWithVars(query, Collections.emptyMap());
    }

    public DgraphProto.Response mutate(DgraphProto.Mutation mutation) {
        return ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.mutate(mutation).join());
    }

    public DgraphProto.Response doRequest(DgraphProto.Request request) {
        return ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.doRequest(request).join());
    }

    public void commit() {
        ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.commit().join());
    }

    public void discard() {
        ExceptionUtil.withExceptionUnwrapped(() -> this.asyncTransaction.discard().join());
    }

    public void setBestEffort(boolean bestEffort) {
        this.asyncTransaction.setBestEffort(bestEffort);
    }

    @Override
    public void close() {
        ExceptionUtil.withExceptionUnwrapped(this::discard);
    }
}

